/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: TransitionCheckVisitor.cc,v $
$Revision: 1.6 $
$Date: 1997/07/02 04:45:26 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: TransitionCheckVisitor.cc,v $
Revision 1.6  1997/07/02 04:45:26  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.5  1997/05/20 05:15:38  andrewm
Checkpoint.  Improved the structure of the "State" class and this
had quite some ripple effects.  However, now there is an abstract
class "State" with two concrete classes "PseudoState" to represent
error and ignore and "RealState" to represent the user specified
states.  Also improved the text display of event names on the transitions.

Revision 1.4  1997/04/16 04:06:16  andrewm
Checkpoint, as last major dialog is in.

Revision 1.3  1996/12/26 05:55:30  andrewm
Checkpoint, the compiler is working again.

Revision 1.2  1996/10/01 04:39:38  andrewm
checkpoint and revision

// Revision 1.1  1996/09/22  01:18:50  andrewm
// pre-alpha release
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <string>

#include "MachEvent.h"
#include "State.h"
#include "Transition.h"
#include "Parameter.h"
#include "TransitionCheckVisitor.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: TransitionCheckVisitor.cc,v $ $Revision: 1.6 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

void TransitionCheckVisitor::
visit(
	Transition *transition)
{
	bool in_error = false ;
	MachEvent *event = transition->event() ;
	State *destination = transition->destination() ;
	if (!destination->is_pseudo_state())
	{
		MachEvent::ParameterList& ep_list = event->parameter_list() ;
		MachEvent::ParameterListIter ep_iter = ep_list.begin() ;
		const State::ParameterList& sp_list = destination->parameter_list() ;
		State::ParameterListConstIter sp_iter = sp_list.begin() ;

		for ( ; ep_iter != ep_list.end() && sp_iter != sp_list.end() ;
			ep_iter++, sp_iter++)
		{
			Parameter *event_param = *ep_iter ;
			Parameter *state_param = *sp_iter ;
			string event_type(event_param->type()) ;
			string state_type(state_param->type()) ;
			if (event_type.compare(state_type) != 0)
			{
				in_error = true ;
				break ;
			}
		}

		if (ep_iter != ep_list.end() || sp_iter != sp_list.end()
			|| in_error == true)
		{
			_trans_mismatch.push_back(transition) ;
		}
	}
}

ostream&
operator <<(
	ostream& s,
	TransitionCheckVisitor& tcv)
{
	for (TransitionCheckVisitor::TransitionVector::iterator tcv_iter =
		tcv._trans_mismatch.begin() ; tcv_iter != tcv._trans_mismatch.end() ;
		++tcv_iter)
	{
		s << **tcv_iter << endl ;
	}
	return s ;
}
