/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: MachineVisitor.cc,v $
$Revision: 1.4 $
$Date: 1997/07/02 04:45:24 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MachineVisitor.cc,v $
Revision 1.4  1997/07/02 04:45:24  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.3  1997/05/20 05:15:37  andrewm
Checkpoint.  Improved the structure of the "State" class and this
had quite some ripple effects.  However, now there is an abstract
class "State" with two concrete classes "PseudoState" to represent
error and ignore and "RealState" to represent the user specified
states.  Also improved the text display of event names on the transitions.

Revision 1.2  1996/12/26 05:55:29  andrewm
Checkpoint, the compiler is working again.

Revision 1.1  1996/09/22 01:18:50  andrewm
pre-alpha release

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "MachineVisitor.h"
#include "MachineGroup.h"
#include "Smachine.h"
#include "MachEvent.h"
#include "State.h"
#include "Transition.h"
#include "Parameter.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: MachineVisitor.cc,v $ $Revision: 1.4 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

MachineVisitor::
MachineVisitor()
{
}

void MachineVisitor::
visit(
	MachineGroup *group)
{
	MachineGroup::SmachineList& machine_list = group->machine_list() ;
	for (MachineGroup::SmachineListIter sm_iter = machine_list.begin() ;
		sm_iter != machine_list.end() ; sm_iter++)
	{
		Smachine *sm = *sm_iter ;
		sm->accept_visitor(*this) ;
	}
}

void MachineVisitor::
visit(
	Smachine *machine)
{
	Smachine::StateList& state_list = machine->state_list() ;
	for (Smachine::StateListIter st_iter = state_list.begin() ;
		st_iter != state_list.end() ; st_iter++)
	{
		State *st = *st_iter ;
		st->accept_visitor(*this) ;
	}

	Smachine::MachEventList& event_list = machine->event_list() ;
	for (Smachine::MachEventListIter ev_iter = event_list.begin() ;
		ev_iter != event_list.end() ; ev_iter++)
	{
		MachEvent *ev = *ev_iter ;
		ev->accept_visitor(*this) ;
	}
}

void MachineVisitor::
visit(
	MachEvent *event)
{
	MachEvent::ParameterList& param_list = event->parameter_list() ;
	for (MachEvent::ParameterListIter param_iter = param_list.begin() ;
		param_iter != param_list.end() ; param_iter++)
	{
		Parameter *param = *param_iter ;
		param->accept_visitor(*this) ;
	}
}

void MachineVisitor::
visit(
	State *state)
{
	const State::ParameterList& param_list = state->parameter_list() ;
	for (State::ParameterListConstIter param_iter = param_list.begin() ;
		param_iter != param_list.end() ; param_iter++)
	{
		Parameter *param = *param_iter ;
		param->accept_visitor(*this) ;
	}

	const State::TransitionList& trans_list = state->transition_list() ;
	for (State::TransitionListConstIter tr_iter = trans_list.begin() ;
		tr_iter != trans_list.end() ; tr_iter++)
	{
		Transition *tr = *tr_iter ;
		tr->accept_visitor(*this) ;
	}
}

void MachineVisitor::
visit(
	Transition *transition)
{
}

void MachineVisitor::
visit(
	Parameter *parameter)
{
}
