/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: ForwardRefVisitor.cc,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:45:23 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: ForwardRefVisitor.cc,v $
Revision 1.5  1997/07/02 04:45:23  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/05/15 04:14:47  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.3  1997/01/12 02:17:47  andrewm
Changed the compiler so that state machine is defined as nested
classes in order to prevent polluting the global class name space.

Revision 1.2  1996/12/26 05:55:28  andrewm
Checkpoint, the compiler is working again.

Revision 1.1  1996/09/22 01:18:50  andrewm
pre-alpha release

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "ForwardRefVisitor.h"
#include "Smachine.h"
#include "MachEvent.h"
#include "State.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: ForwardRefVisitor.cc,v $ $Revision: 1.5 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

ForwardRefVisitor::
ForwardRefVisitor(
	ostream& stream) :
		_headerfile(stream)
{
}

void ForwardRefVisitor::
visit(
	Smachine *machine)
{
	_prefix_name = machine->name().var_name() ;
	_headerfile << "\n\t// Forward References" << endl ;
	MachineVisitor::visit(machine) ;
}

void ForwardRefVisitor::
visit(
	State *state)
{
	_headerfile << "\tclass " << _prefix_name << '_' << state->name().var_name()
		<< "_State ;" << endl ;
}
