/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: EventDefVisitor.cc,v $
$Revision: 1.7 $
$Date: 1997/07/02 04:45:22 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: EventDefVisitor.cc,v $
Revision 1.7  1997/07/02 04:45:22  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.6  1997/05/20 05:15:36  andrewm
Checkpoint.  Improved the structure of the "State" class and this
had quite some ripple effects.  However, now there is an abstract
class "State" with two concrete classes "PseudoState" to represent
error and ignore and "RealState" to represent the user specified
states.  Also improved the text display of event names on the transitions.

Revision 1.5  1997/05/15 04:14:47  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.4  1997/01/12 02:17:47  andrewm
Changed the compiler so that state machine is defined as nested
classes in order to prevent polluting the global class name space.

Revision 1.3  1996/12/27 02:11:01  andrewm
Checkpoint before attempting to restructure the compiler to generate
nested class declarations.

Revision 1.2  1996/12/26 05:55:27  andrewm
Checkpoint, the compiler is working again.

Revision 1.1  1996/09/22 01:18:50  andrewm
pre-alpha release

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "EventDefVisitor.h"
#include "MachineGroup.h"
#include "Smachine.h"
#include "MachEvent.h"
#include "State.h"
#include "Transition.h"
#include "Parameter.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: EventDefVisitor.cc,v $ $Revision: 1.7 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

EventDefVisitor::
EventDefVisitor(
	ostream& stream) :
		_codefile(stream)
{
}

void EventDefVisitor::
visit(
	Smachine *machine)
{
	_prefix_name = machine->name().var_name() ;
	string event_class = _prefix_name + "::" + _prefix_name + "_Event" ;

	_codefile << "// Event definitions for " << _prefix_name << endl ;

	_codefile <<
		"ostream&\n"
		"operator <<(\n"
			"\tostream& s,\n"
			"\tconst " << event_class << "& event)\n"
		"{\n"
			"\treturn s << event.name() ;\n"
		"}" << endl ;

	State *initial_state = machine->initial_state() ;
	if (initial_state)
	{
		_codefile <<
			"void " << _prefix_name << "::"
				<< _prefix_name << "_InitialEvent::\n"
			"transition(\n" <<
				'\t' << _prefix_name << "& machine) const\n"
			"{\n"
				"\tmachine.current_state()->initial_event(machine, *this" ;

		const State::ParameterList& param_list =
			initial_state->parameter_list() ;
		for (State::ParameterListConstIter param_iter = param_list.begin() ;
			param_iter != param_list.end() ; param_iter++)
		{
			Parameter *param = *param_iter ;
			param->accept_visitor(*this) ;
		}
		_codefile <<
				") ;\n"
			"}" << endl ;
	}

	Smachine::MachEventList& event_list = machine->event_list() ;
	for (Smachine::MachEventListIter event_iter = event_list.begin() ;
		event_iter != event_list.end() ; event_iter++)
	{
		MachEvent *ev = *event_iter ;
		ev->accept_visitor(*this) ;
	}
}

void EventDefVisitor::
visit(
	MachEvent *event)
{
	string event_name = event->name().var_name() ;
	string event_class =
		_prefix_name + "::" + _prefix_name + "_" + event_name + "_Event" ;

	_codefile <<
		"void " << event_class << "::\n"
		"transition(\n" <<
			'\t' << _prefix_name << "& machine) const\n"
		"{\n"
			"\tmachine.current_state()->" << event_name <<
				"(machine, *this" ;

	MachEvent::ParameterList& param_list = event->parameter_list() ;
	for (MachEvent::ParameterListIter param_iter = param_list.begin() ;
		param_iter != param_list.end() ; param_iter++)
	{
		Parameter *param = *param_iter ;
		param->accept_visitor(*this) ;
	}

	_codefile <<
			") ;\n"
		"}" << endl ;
}

void EventDefVisitor::
visit(
	Parameter *parameter)
{
	_codefile << 
		", _" << (const string&)parameter->name() ;
}
