/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: CcHeaderVisitor.cc,v $
$Revision: 1.6 $
$Date: 1997/07/02 04:45:21 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: CcHeaderVisitor.cc,v $
Revision 1.6  1997/07/02 04:45:21  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.5  1997/01/12 02:17:46  andrewm
Changed the compiler so that state machine is defined as nested
classes in order to prevent polluting the global class name space.

Revision 1.4  1996/12/26 05:55:27  andrewm
Checkpoint, the compiler is working again.

Revision 1.3  1996/11/17 21:50:54  andrewm
Converting to the new version of g++ (2.7.2) and now everything
is under CVS.

Revision 1.2  1996/10/01 04:39:38  andrewm
checkpoint and revision

// Revision 1.1  1996/09/22  01:18:50  andrewm
// pre-alpha release
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <errno.h>

#include "CcHeaderVisitor.h"
#include "MachineGroup.h"
#include "Smachine.h"
#include "MachineDeclVisitor.h"
#include "CleanName.h"

#include <algorithm>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: CcHeaderVisitor.cc,v $ $Revision: 1.6 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/


CcHeaderVisitor::
CcHeaderVisitor(
	const string& filename) :
		_filename(filename),
		_headerfile(ofstream(filename.c_str()))
{
	static const char underscore[] = "_" ;

	_include_define = underscore ;
	_include_define += _filename ;
	_include_define += underscore ;

	transform(_include_define.begin(), _include_define.end(),
		_include_define.begin(), CleanName()) ;
}

void CcHeaderVisitor::
visit(
	MachineGroup *group)
{
	if (!_headerfile)
	{
		cerr << "Cannot open \"" << _filename << "\" for output: " <<
			strerror(errno) << endl ;
		return ;
	}
	_headerfile <<
		"// This file is automatically generated and should not be edited.\n"
		"#ifndef\t" << _include_define <<
		"\n#define\t" << _include_define << endl <<
		"#ifdef __GNUG__\n"
		"#\tpragma interface\n"
		"#endif /* __GNUG__ */\n"
		"#include <iostream.h>\n"
		<< endl ;

	MachineVisitor::visit(group) ;

	_headerfile <<
		"\n\n#endif /* " << _include_define << " */" << endl ;
}

void CcHeaderVisitor::
visit(
	Smachine *machine)
{
	MachineDeclVisitor mdv(_headerfile) ;
	machine->accept_visitor(mdv) ;
}
