/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: PageGroup.h,v $
$Revision: 1.10 $
$Date: 1997/07/02 04:45:19 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: PageGroup.h,v $
Revision 1.10  1997/07/02 04:45:19  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.9  1997/06/06 04:34:28  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.8  1997/02/08 04:37:43  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.7  1997/01/23 06:20:56  andrewm
Checkpoint as base and graphics classes are operating together.

Revision 1.6  1996/11/14 06:19:54  andrewm
checkpoint

 * Revision 1.5  1996/10/01  04:39:26  andrewm
 * checkpoint and revision
 *
 * Revision 1.4  1996/09/22  01:45:36  andrewm
 * pre-alpha release
 *
 * Revision 1.3  1996/08/18  17:58:13  andrewm
 * checkpoint
 *
 * Revision 1.3  1996/08/18  17:58:13  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/08/05  01:25:56  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/06/26  03:16:15  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _PageGroup_h_
#define _PageGroup_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Observer.h"
#include <list>

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class MachineGroup ;
class Smachine ;
class Page ;

class PageGroup :
	public Observer
{
public:
	typedef list<Page *> PageList ;
	typedef list<Page *>::iterator PageListIter ;
	typedef list<Page *>::const_iterator PageListConstIter ;

public:
	PageGroup(MachineGroup *machine_group) ;

	MachineGroup *machine_group() { return _machine_group ; }

	Page *find_page(Smachine *machine) ;
	Page *find_page(const char *machine_name) ;
	void remove_page(Page *page) ;
	PageList& page_list(void) { return _page_list ; }

	void draw() ;

	virtual void update(const Subject *subject) ;
	virtual void subject_deleted(Subject *subject) ;

private:
	MachineGroup *_machine_group ;
	PageList _page_list ;

private:
	PageGroup& operator =(const PageGroup& pg) ; // no assignments
} ;



#endif /* _PageGroup_h_ */
