/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: PageGroup.cc,v $
$Revision: 1.12 $
$Date: 1997/07/02 04:45:18 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: PageGroup.cc,v $
Revision 1.12  1997/07/02 04:45:18  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.11  1997/06/06 04:34:28  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.10  1997/03/04 06:32:58  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.9  1997/02/08 04:37:43  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.8  1997/01/23 06:20:56  andrewm
Checkpoint as base and graphics classes are operating together.

Revision 1.7  1996/11/17 21:50:53  andrewm
Converting to the new version of g++ (2.7.2) and now everything
is under CVS.

Revision 1.6  1996/11/14 06:19:54  andrewm
checkpoint

// Revision 1.5  1996/10/01  04:39:26  andrewm
// checkpoint and revision
//
// Revision 1.4  1996/09/22  01:52:15  andrewm
// pre-alpha release
//
// Revision 1.3  1996/08/18  17:58:13  andrewm
// checkpoint
//
// Revision 1.3  1996/08/18  17:58:13  andrewm
// checkpoint
//
// Revision 1.2  1996/08/05  01:25:56  andrewm
// checkpoint
//
// Revision 1.1  1996/06/26  03:16:15  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "MachineGroup.h"
#include "PageGroup.h"
#include "Page.h"

#include <assert.h>
#include <algorithm>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: PageGroup.cc,v $ $Revision: 1.12 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

PageGroup::
PageGroup(
	MachineGroup *machine_group) :
		_machine_group(machine_group)
{
	_machine_group->attach(this) ;

	MachineGroup::SmachineList& mlist = _machine_group->machine_list() ;
	for (MachineGroup::SmachineListIter sm_iter = mlist.begin() ;
		sm_iter != mlist.end() ; ++sm_iter)
	{
		_page_list.push_back(new Page(this, *sm_iter)) ;
	}
}

PageGroup::
~PageGroup()
{
	if (_machine_group)
		_machine_group->detach(this) ;

	for (PageListIter pg_iter = _page_list.begin() ;
		pg_iter != _page_list.end() ; ++pg_iter)
	{
		Page *page = *pg_iter ;
		page->orphan() ;
		delete page ;
	}
}

Page *PageGroup::
find_page(
	Smachine *machine)
{
	for (PageListIter pg_iter = _page_list.begin() ;
		pg_iter != _page_list.end() ; ++pg_iter)
	{
		Page *page = *pg_iter ;
		if (page->machine() == machine)
			return page ;
	}
	return (Page *)NULL ;
}

Page *PageGroup::
find_page(
	const char *machine_name)
{
	Smachine *machine = _machine_group->find_machine(machine_name) ;
	return (machine ? find_page(machine) : (Page *)NULL) ;
}

void PageGroup::
remove_page(
	Page *page)
{
	page->orphan() ;
	_page_list.remove(page) ;
}

void PageGroup::
draw()
{
	for (PageListConstIter pg_iter = _page_list.begin() ;
		pg_iter != _page_list.end() ; ++pg_iter)
	{
		Page *page = *pg_iter ;
		page->draw() ;
	}
}

void PageGroup::
update(
	const Subject *subject)
{
	assert(subject == _machine_group) ;
	MachineGroup::SmachineList& mlist = _machine_group->machine_list() ;
	for (MachineGroup::SmachineListIter sm_iter = mlist.begin() ;
		sm_iter != mlist.end() ; ++sm_iter)
	{
		Smachine *sm = *sm_iter ;
		if (!find_page(sm))
			_page_list.push_back(new Page(this, sm)) ;
	}
}

void PageGroup::
subject_deleted(
	Subject *subject)
{
	assert(subject == _machine_group) ;
	_machine_group = NULL ;
	delete this ;
}
