/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Page.cc,v $
$Revision: 1.15 $
$Date: 1997/07/02 04:45:18 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Page.cc,v $
Revision 1.15  1997/07/02 04:45:18  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.14  1997/06/06 04:34:28  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.13  1997/05/20 05:15:35  andrewm
Checkpoint.  Improved the structure of the "State" class and this
had quite some ripple effects.  However, now there is an abstract
class "State" with two concrete classes "PseudoState" to represent
error and ignore and "RealState" to represent the user specified
states.  Also improved the text display of event names on the transitions.

Revision 1.12  1997/03/04 06:32:57  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.11  1997/02/08 04:37:43  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.10  1997/01/23 06:20:55  andrewm
Checkpoint as base and graphics classes are operating together.

Revision 1.9  1996/11/27 01:25:53  andrewm
Another checkpoint before I go off and figure out what to do about
the graphical representations so that I'll be able to get some post script
output one of these days.

Revision 1.8  1996/11/17 21:50:53  andrewm
Converting to the new version of g++ (2.7.2) and now everything
is under CVS.

Revision 1.7  1996/11/14 06:19:54  andrewm
checkpoint

// Revision 1.6  1996/10/01  04:39:26  andrewm
// checkpoint and revision
//
// Revision 1.5  1996/09/22  01:18:34  andrewm
// pre-alpha release
//
// Revision 1.4  1996/08/18  17:58:13  andrewm
// checkpoint
//
// Revision 1.3  1996/08/05  01:25:56  andrewm
// checkpoint
//
// Revision 1.2  1996/07/27  20:57:09  andrewm
// checkpoint
//
// Revision 1.1  1996/06/26  03:16:15  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Smachine.h"
#include "State.h"
#include "StateGraphic.h"
#include "Page.h"
#include "PageGroup.h"
#include "GraphicRenderer.h"

#include <assert.h>
#include <algorithm>
#include <functional>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: Page.cc,v $ $Revision: 1.15 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

Page::
Page(
	PageGroup *parent,
	Smachine *machine) :
		_parent(parent),
		_machine(machine)
{
	_machine->attach(this) ;

	Smachine::StateList& slist = _machine->state_list() ;
	for (Smachine::StateListIter s_iter = slist.begin() ;
		s_iter != slist.end() ; ++s_iter)
	{
		State *state = *s_iter ;
		if (state->is_real_state())
			_state_graphic_list.push_back(new StateGraphic(this, state)) ;
	}
}

Page::
~Page()
{
	if (_machine)
		_machine->detach(this) ;
	if (_parent)
		_parent->remove_page(this) ;

	for (StateGraphicListIter sg_iter = _state_graphic_list.begin() ;
		sg_iter != _state_graphic_list.end() ; ++sg_iter)
	{
		StateGraphic *sg = *sg_iter ;
		sg->orphan() ;
		delete sg ;
	}
}

StateGraphic *Page::
find_state_graphic(
	State *state)
{
	class StateGraphicCmp :
		public binary_function<StateGraphic *, State *, bool>
	{
	public:
		bool operator ()(StateGraphic *sg, State *st) const {
			return sg->state() == st ;
		}
	} ;

	StateGraphicListIter end = _state_graphic_list.end() ;
	StateGraphicListIter found = find_if(_state_graphic_list.begin(),
		end, bind2nd(StateGraphicCmp(), state)) ;

	return found == end ? (StateGraphic *)NULL : *found ;
}

StateGraphic *Page::
find_state_graphic(
	const char *state_name)
{
	State *state = _machine->find_state(state_name) ;
	return (state ? find_state_graphic(state) : (StateGraphic *)NULL) ;
}

void Page::
remove_state_graphic(
	StateGraphic *state_graphic)
{
	state_graphic->orphan() ;
	_state_graphic_list.remove(state_graphic) ;
}

void Page::
draw()
{
	class StateDraw
	{
	public:
		void operator ()(StateGraphic *sg) { sg->draw() ; }
	} ;

	for_each(_state_graphic_list.begin(), _state_graphic_list.end(),
		StateDraw()) ;
}

void Page::
update(
	const Subject *subject)
{
	assert(subject == _machine) ;
	Smachine::StateList& slist = _machine->state_list() ;
	for (Smachine::StateListIter s_iter = slist.begin() ;
		s_iter != slist.end() ; ++s_iter)
	{
		State *state = *s_iter ;
		if (state->is_real_state() && !find_state_graphic(state))
		{
			StateGraphic *sg = new StateGraphic(this, state) ;
			_state_graphic_list.push_back(sg) ;
			sg->draw() ;
		}
	}
}

void Page::
subject_deleted(
	Subject *subject)
{
	assert(subject == _machine) ;
	_machine = NULL ;
	delete this ;
}
