/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: PSGraphicRenderer.h,v $
$Revision: 1.5 $
$Date: 1997/07/14 02:30:35 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: PSGraphicRenderer.h,v $
Revision 1.5  1997/07/14 02:30:35  andrewm
Checkpoint.  Rework makefiles.  Rework man pages.  Fixed PostScript problems.

Revision 1.4  1997/07/02 04:45:18  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.3  1997/06/21 02:21:35  andrewm
Checkpoint.  PostScript generator going well. A lot of small tweeks
all over to accomplish this.

Revision 1.2  1997/06/15 00:43:57  andrewm
Another checkpoint.  Reworked the way text is specfied to be drawn
for the benefit of the post script renderer.

Revision 1.1  1997/06/12 03:20:26  andrewm
Checkpoint.  Crude version of the PostScript output running.  Need
to change the way text is manipulated in order to make PostScript generation
better.

 *--
 */
#ifndef _PSGraphicRenderer_h_
#define _PSGraphicRenderer_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "GraphicRenderer.h"
#include <iostream.h>
#include <Geom2d.h>

/*
MACRO DEFINITIONS
*/

/*
CLASS REFERENCES
*/

/*
CLASS DEFINITIONS
*/
struct XPoint ;


class PSGraphicRenderer :
	public GraphicRenderer
{
public:
	enum Orientation
	{
		BestFit,
		Portrait,
		Landscape,
	} ;

public:
	PSGraphicRenderer(ostream& s) ;
	virtual ~PSGraphicRenderer() ;

	void orientation(Orientation new_orientation) {
		_orientation = new_orientation ; }
	Orientation orientation() { return _orientation ; }
	void page_width(float new_width) { _page_width = new_width ; }
	float page_width() const { return _page_width ; }
	void page_height(float new_height) { _page_height = new_height ; }
	float page_height() const { return _page_height ; }
	void left_margin(float new_margin) { _left_margin = new_margin ; }
	float left_margin() const { return _left_margin ; }
	void right_margin(float new_margin) { _right_margin = new_margin ; }
	float right_margin() const { return _right_margin ; }
	void top_margin(float new_margin) { _top_margin = new_margin ; }
	float top_margin() const { return _top_margin ; }
	void bottom_margin(float new_margin) { _bottom_margin = new_margin ; }
	float bottom_margin() const { return _bottom_margin ; }

	void start(const string& media, const char *creator,
		const Rectangle& bounding) ;
	void end() ;
	void start_page(const Rectangle& bounding) ;
	void end_page() ;

	virtual Point scale_to_mm(const Point& point) ;
	virtual void circle(const Circle& circle) ;
	virtual void circular_arc(const Circle& circle, float start, float extent) ;
	virtual void rect(const Rectangle& rectangle) ;
	virtual void fillrect(const Rectangle& rectangle) ;
	virtual void line(const Point& begin_pt, const Point& end_pt) ;
	virtual void lines(const PointList& points) ;
	virtual void fillpolygon(const PointList& points) ;
	virtual void text(const string& text, const Point& location,
		TextOrigin origin) ;
	virtual Point text_extent(const string& text) ;
	virtual float line_width() ;
	virtual LineDrawingStyle line_style(LineDrawingStyle new_style) ;
	virtual void clear() ;

	virtual void clear_clip() ;
	virtual void add_rectangle_to_clip(const Rectangle& rect) ;
	virtual void set_clip() ;

private:
	void setup() ;
	Point scale_to_points(const Point& point) ;
	Circle scale_to_points(const Circle& circle) ;
	Rectangle scale_to_points(const Rectangle& rectangle) ;
	Rectangle calc_ps_bounding() ;

private:
	ostream& _stream ;
	bool _running ;
	unsigned _page_count ;
	Orientation _orientation ;
	float _page_width ;
	float _page_height ;
	float _left_margin ;
	float _right_margin ;
	float _top_margin ;
	float _bottom_margin ;
	float _page_scale ;
	Rectangle _bounding ;
	Rectangle _doc_bounding ;

private:
	static const float _points_per_mm ;
} ;

ostream& operator <<(ostream& s, PSGraphicRenderer::Orientation orientation) ;


#endif /* _PSGraphicRenderer_h_ */
