/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: GraphicRenderer.h,v $
$Revision: 1.9 $
$Date: 1997/07/02 04:45:17 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: GraphicRenderer.h,v $
Revision 1.9  1997/07/02 04:45:17  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.8  1997/06/21 02:21:34  andrewm
Checkpoint.  PostScript generator going well. A lot of small tweeks
all over to accomplish this.

Revision 1.7  1997/06/15 00:43:56  andrewm
Another checkpoint.  Reworked the way text is specfied to be drawn
for the benefit of the post script renderer.

Revision 1.6  1997/03/18 06:51:04  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.5  1997/03/12 03:13:08  andrewm
Checkpoint.  Things are working rather well.

Revision 1.4  1997/03/04 06:32:57  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.3  1997/02/23 23:44:16  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.2  1997/02/08 04:37:42  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.1  1997/01/23 06:20:55  andrewm
Checkpoint as base and graphics classes are operating together.

 *--
 */
#ifndef _GraphicRenderer_h_
#define _GraphicRenderer_h_

/*
PRAGMAS
*/

/*
INCLUDE FILES
*/
#include "Geom2d.h"
#include <string>
#include <vector>

/*
MACRO DEFINITIONS
*/

/*
CLASS REFERENCES
*/

/*
CLASS DEFINITIONS
*/

class GraphicRenderer
{
public:
	typedef vector<Point> PointList ;
	typedef vector<Point>::iterator PointListIter ;
	typedef vector<Point>::const_iterator PointListConstIter ;

	enum LineDrawingStyle
	{
		LS_NORMAL,
		LS_DASHED,
	} ;
	enum TextOrigin
	{
		Origin_Center,
		Origin_NorthWest,
		Origin_North,
		Origin_NorthEast,
		Origin_East,
		Origin_SouthEast,
		Origin_South,
		Origin_SouthWest,
		Origin_West
	} ;

public:
	virtual Point scale_to_mm(const Point& point) = 0 ;
	virtual void circle(const Circle& circle) = 0 ;
	virtual void circular_arc(const Circle& circle, float start,
		float extent) = 0 ;
	virtual void rect(const Rectangle& rectangle) = 0 ;
	virtual void fillrect(const Rectangle& rectangle) = 0 ;
	virtual void line(const Point& begin_pt, const Point& end_pt) = 0 ;
	virtual void lines(const PointList& lines) = 0 ;
	virtual void fillpolygon(const PointList& points) = 0 ;
	virtual void text(const string& text, const Point& location,
		TextOrigin origin = Origin_Center) = 0 ;
	virtual Point text_extent(const string& text) = 0 ;
	virtual float line_width() = 0 ;
	virtual LineDrawingStyle line_style(LineDrawingStyle new_style) = 0 ;
	virtual void clear() = 0 ;

	virtual void clear_clip() = 0 ;
	virtual void add_rectangle_to_clip(const Rectangle& rect) = 0 ;
	virtual void set_clip() = 0 ;


public:
	static GraphicRenderer& instance(GraphicRenderer *instance) ;
	static GraphicRenderer& instance() ;

private:
	static GraphicRenderer *_instance ;
} ;



#endif /* _GraphicRenderer_h_ */
