/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: SubProcess.cc,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:45:17 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: SubProcess.cc,v $
Revision 1.5  1997/07/02 04:45:17  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/02/23 23:44:15  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.3  1997/01/23 06:19:50  andrewm
Checkpoint as base and graphics classes stabilize.
Observer/subject pattern operating between base and graphic classes.

Revision 1.2  1996/09/22 01:22:58  andrewm
*** empty log message ***

// Revision 1.1  1996/08/05  01:25:23  andrewm
// Initial revision
//
// Revision 1.1  1996/08/05  01:25:23  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <iostream.h>
#include <assert.h>
#include <sys/wait.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <stdarg.h>

#include "SubProcess.h"
#include "Command.h"

#include <list>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: SubProcess.cc,v $ $Revision: 1.5 $" ;

/*
STATIC MEMBER DEFINITIONS
*/
SubProcess::SubProcessList SubProcess::_subprocess_list ;
XtSignalId SubProcess::_sigchld_id = 0 ;

/*
FUNCTION DEFINITIONS
*/

SubProcess::
SubProcess(
	Command *exit_command) :
		_exit_command(exit_command),
		_pid(0)
{
}

SubProcess::
~SubProcess()
{
}

pid_t SubProcess::
run(
	const char *command
	...)
{
	va_list ap ;
	va_start(ap, command) ;

	_pid = fork() ;
	switch (_pid)
	{
	case 0: // child process
		execvp(command, (char *const [])ap) ;
			// command not found
		perror(command) ;
		_exit(255) ;
		break ;

	case -1: // error in fork
		cerr << "fork() failed: " << strerror(errno) << endl ;
		break ;

	default:
		_subprocess_list.push_back(this) ;
	}
	va_end(ap) ;

	return _pid ;
}

bool SubProcess::
stop(
	int signal_id)
{
	return kill(_pid, signal_id) == 0 ;
}

void SubProcess::
install_signalling(
	XtAppContext app_context)
{
	_sigchld_id = XtAppAddSignal(app_context, sigchld_callback, NULL) ;
	signal(SIGCHLD, sigchld_handler) ;
}

void SubProcess::
sigchld_callback(
	XtPointer closure,
	XtSignalId *id)
{
	assert(*id == _sigchld_id) ;
	pid_t pid ;
	while ((pid = waitpid(-1, NULL, WNOHANG)) > 0)
	{
		for (SubProcessListIter sp_iter = _subprocess_list.begin() ;
			sp_iter != _subprocess_list.end() ; ++sp_iter)
		{
			SubProcess *sp = *sp_iter ;
			if (sp->_pid == pid)
			{
				sp->_exit_command->execute() ;
				break ;
			}
		}
	}
		// reinstall the signal; default behavior seems to
		// require it unless I can figure out how to use the
		// fancier calls to set the appropriate flags so that
		// the signal doesn't have to be reinstalled all the time.
	signal(SIGCHLD, sigchld_handler) ;
}

void SubProcess::
sigchld_handler(
	int signum)
{
	XtNoticeSignal(_sigchld_id) ;
}
