/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: PageSize.cc,v $
$Revision: 1.2 $
$Date: 1997/07/02 04:45:16 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: PageSize.cc,v $
Revision 1.2  1997/07/02 04:45:16  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.1  1997/06/21 02:21:34  andrewm
Checkpoint.  PostScript generator going well. A lot of small tweeks
all over to accomplish this.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "PageSize.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: PageSize.cc,v $ $Revision: 1.2 $" ;

/*
STATIC MEMBER DEFINITIONS
*/
list<PageSize *> PageSize::_pages ;
PageSize PageSize::letter("letter", 215.9, 279.4) ;
PageSize PageSize::legal("legal", 215.9, 355.6) ;
PageSize PageSize::ledger("ledger", 431.8, 279.4) ;
PageSize PageSize::tabloid("tabloid", 279.4, 431.8) ;
PageSize PageSize::a4("a4", 210, 297) ;
PageSize PageSize::a3("a3", 297, 420) ;
PageSize PageSize::a2("a2", 420, 594) ;
PageSize PageSize::a1("a1", 594, 840) ;
PageSize PageSize::a0("a0", 840, 1188) ;

/*
FUNCTION DEFINITIONS
*/

PageSize::
PageSize(
	const char *name,
	float width,
	float height) :
		_name(name),
		_width(width),
		_height(height)
{
	_pages.push_back(this) ;
}

PageSize::
~PageSize()
{
	_pages.remove(this) ;
}

bool
operator ==(
	const PageSize& ps1,
	const PageSize& ps2)
{
	return ps1._name == ps2._name ;
}

bool
operator !=(
	const PageSize& ps1,
	const PageSize& ps2)
{
	return !(ps1 == ps2) ;
}

PageSize * PageSize::
find(
	const char *name)
{
	string name_string(name) ;
	for (list<PageSize *>::const_iterator iter = _pages.begin() ;
		iter != _pages.end() ; ++iter)
	{
		PageSize *ps = *iter ;
		if (ps->_name == name_string)
			return ps ;
	}
	return NULL ;
}
