/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Observer.h,v $
$Revision: 1.8 $
$Date: 1997/07/02 04:45:16 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Observer.h,v $
Revision 1.8  1997/07/02 04:45:16  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.7  1997/06/06 04:34:27  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.6  1997/03/12 03:13:08  andrewm
Checkpoint.  Things are working rather well.

Revision 1.5  1997/03/04 06:32:56  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.4  1997/02/08 04:37:42  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.3  1997/01/23 06:19:50  andrewm
Checkpoint as base and graphics classes stabilize.
Observer/subject pattern operating between base and graphic classes.

Revision 1.2  1996/09/22 01:22:58  andrewm
*** empty log message ***

 * Revision 1.1  1996/07/27  20:56:24  andrewm
 * Initial revision
 *
 * Revision 1.1  1996/07/27  20:56:24  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _Observer_h_
#define _Observer_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <list>

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Subject ;

class Observer
{
public:
	virtual ~Observer() ;
	virtual void update(const Subject *subject) = 0 ;
	virtual void subject_deleted(Subject *subject) = 0 ;

protected:
	Observer() ;
} ;

class Subject
{
public:
	virtual ~Subject() ;

	virtual void attach(Observer *observer) ;
	virtual void detach(Observer *observer) ;
	virtual void notify() const ;

protected:
	Subject() ;

protected:
	list<Observer *> _observer_list ;

private:
	Subject& operator =(const Subject& subject) ; // no assigments
} ;


#endif /* _Observer_h_ */
