/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Observer.cc,v $
$Revision: 1.8 $
$Date: 1997/07/02 04:45:16 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Observer.cc,v $
Revision 1.8  1997/07/02 04:45:16  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.7  1997/06/06 04:34:27  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.6  1997/03/12 03:13:08  andrewm
Checkpoint.  Things are working rather well.

Revision 1.5  1997/03/04 06:32:56  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.4  1997/02/08 04:37:42  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.3  1997/01/23 06:19:49  andrewm
Checkpoint as base and graphics classes stabilize.
Observer/subject pattern operating between base and graphic classes.

Revision 1.2  1996/09/22 01:22:58  andrewm
*** empty log message ***

// Revision 1.1  1996/07/27  20:56:24  andrewm
// Initial revision
//
// Revision 1.1  1996/07/27  20:56:24  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Observer.h"
#include <algorithm>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: Observer.cc,v $ $Revision: 1.8 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

Observer::
Observer()
{
}

Observer::
~Observer()
{
}

Subject::
Subject()
{
}

Subject::
~Subject()
{
	for (list<Observer *>::iterator l_iter = _observer_list.begin() ;
		l_iter != _observer_list.end() ; ++l_iter)
	{
		Observer *observer = *l_iter ;
		observer->subject_deleted(this) ;
	}
}

void Subject::
attach(
	Observer *observer)
{
	_observer_list.push_back(observer) ;
}

void Subject::
detach(
	Observer *observer)
{
	_observer_list.remove(observer) ;
}

void Subject::
notify() const
{
	for (list<Observer *>::const_iterator l_iter = _observer_list.begin() ;
		l_iter != _observer_list.end() ; ++l_iter)
	{
		Observer *observer = *l_iter ;
		observer->update(this) ;
	}
}
