/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: FileName.h,v $
$Revision: 1.3 $
$Date: 1997/07/02 04:45:15 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: FileName.h,v $
Revision 1.3  1997/07/02 04:45:15  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.2  1997/03/30 02:07:31  andrewm
Checkpoint.  Things working well. About to change the way
machines are stored in the backing file.

Revision 1.1  1997/02/23 23:44:15  andrewm
Checkpoint.  Things seem to be working reasonably well.

 *--
 */
#ifndef _FileName_h_
#define _FileName_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <iostream.h>
#include <string>
#include <vector>
#include <sys/stat.h>
#include <unistd.h>

/*
MACRO DEFINITIONS
*/

/*
CLASS FORWARD REFERENCES
*/

/*
CLASS DEFINITIONS
*/

class FileName :
	public string
{
	friend ostream& operator <<(ostream& s, const FileName& fn) ;

public:
	typedef vector<string> DirList ;
	typedef vector<string>::iterator DirListIter ;

public:
	FileName() ;
	FileName(const char *path) ;
	FileName(const string& path) ;
	FileName(const char *dir, const char *name) ;

	bool can_stat() const ;
	time_t access_time() const ;
	time_t modify_time() const ;
	time_t change_time() const ;
	off_t file_size() const ;
	bool is_link() const ;
	bool is_regular() const ;
	bool is_dir() const ;

	bool mkdir() const ;
	bool file_delete() const ;
	DirList dir_list() const ;

private:
	bool get_stat(struct stat *file_stat) const ;
} ;


#endif /* _FileName_h_ */
