/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Command.cc,v $
$Revision: 1.6 $
$Date: 1997/07/02 04:45:15 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Command.cc,v $
Revision 1.6  1997/07/02 04:45:15  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.5  1997/02/23 23:44:14  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.4  1997/01/23 06:19:47  andrewm
Checkpoint as base and graphics classes stabilize.
Observer/subject pattern operating between base and graphic classes.

Revision 1.3  1996/09/22 01:22:58  andrewm
*** empty log message ***

// Revision 1.2  1996/07/27  20:56:24  andrewm
// checkpoint
//
// Revision 1.2  1996/07/27  20:56:24  andrewm
// checkpoint
//
// Revision 1.1  1996/07/15  01:20:12  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Command.h"
#include <algorithm>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: Command.cc,v $ $Revision: 1.6 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

MacroCommand::
~MacroCommand()
{
	for (list<Command *>::iterator command_iter = _command_list.begin() ;
		command_iter != _command_list.end() ; ++command_iter)
	{
		delete *command_iter ;
	}
}

void MacroCommand::
execute()
{
	for (list<Command *>::iterator command_iter = _command_list.begin() ;
		command_iter != _command_list.end() ; ++command_iter)
	{
		(*command_iter)->execute() ;
	}
}

void MacroCommand::
add_command(
	Command *command)
{
	_command_list.push_back(command) ;
}

void MacroCommand::
remove_command(
	Command *command)
{
	list<Command *>::iterator end = _command_list.end() ;
	list<Command *>::iterator found =
		find(_command_list.begin(), end, command) ;

	if (found != end)
		_command_list.erase(found) ;
}
