/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: CSutils.h,v $
$Revision: 1.3 $
$Date: 1997/07/02 04:45:14 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: CSutils.h,v $
Revision 1.3  1997/07/02 04:45:14  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.2  1996/09/22 01:22:58  andrewm
*** empty log message ***

 * Revision 1.1  1996/06/26  03:12:53  andrewm
 * Initial revision
 *
 * Revision 1.1  1996/06/26  03:12:53  andrewm
 * Initial revision
 *
 * Revision 1.1  1996/05/26  22:27:43  andrewm
 * Initial revision
 *
 * Revision 1.3  1996/04/01  03:25:19  andrewm
 * Checkpoint after extensive rework of the graphics aspects.
 *
 * Revision 1.2  1996/02/27  04:52:23  andrewm
 * Checkpoint before going in and straightening out some of the
 * class architecture.
 *
 * Revision 1.1  1996/02/19  19:41:00  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _CSutils_h_
#define _CSutils_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

extern XmString TextToCS(const char *text) ;
extern char *CSToText(XmString cs) ;

extern XmStringTable TextArrayToCSTable(char **text_array, int count) ;
extern char **CSTableToTextArray(XmStringTable table, int count) ;

extern void CSTableFree(XmStringTable table, int count) ;
extern void TextArrayFree(char **array, int count) ;


#endif /* _CSutils_h_ */
