/*
 *++
MODULE:

$RCSfile: SMAbstractRetriever.h,v $
$Revision: 1.5 $
$Date: 1996/09/22 01:18:43 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: SMAbstractRetriever.h,v $
Revision 1.5  1996/09/22 01:18:43  andrewm
pre-alpha release

 * Revision 1.4  1996/08/18  17:58:26  andrewm
 * checkpoint
 *
 * Revision 1.3  1996/07/27  20:57:24  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/07/15  01:21:16  andrewm
 * checkpoint again
 *
 * Revision 1.1  1996/06/26  03:17:38  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _SMAbstractRetriever_h_
#define _SMAbstractRetriever_h_

/*
PRAGMAS
*/

/*
INCLUDE FILES
*/

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class SMAbstractRetriever
{
public:
	virtual void retrieve_start() {}
	virtual void retrieve_end() {}

	virtual const char *retrieve_author() { return 0 ; }
	virtual const char *retrieve_revision() { return 0 ; }

	virtual void retrieve_machine_start() {}
	virtual bool retrieve_machine_done() { return true ; }
	virtual void retrieve_machine_next() {}
	virtual const char *retrieve_machine() { return 0 ; }
	virtual const char *retrieve_counter() { return 0 ; }
	virtual const char *retrieve_prolog() { return 0 ; }
	virtual const char *retrieve_epilog() { return 0 ; }
	virtual const char *retrieve_error_action() { return 0 ; }
	virtual const char *retrieve_ignore_action() { return 0 ; }
	virtual const char *retrieve_initial_state() { return 0 ; }
	virtual const char *retrieve_terminal_state() { return 0 ; }
	virtual const char *retrieve_default_state() { return 0 ; }

	virtual void retrieve_event_start() {}
	virtual bool retrieve_event_done() { return true ; }
	virtual void retrieve_event_next() {}
	virtual const char *retrieve_event() { return 0 ; }
	virtual void retrieve_event_parameter_start() {}
	virtual bool retrieve_event_parameter_done() { return true ; }
	virtual void retrieve_event_parameter_next() {}
	virtual void retrieve_event_parameter(const char **type, const char **name)
		{ *type = *name = NULL ; }

	virtual void retrieve_state_start() {}
	virtual bool retrieve_state_done() { return true ; }
	virtual void retrieve_state_next() {}
	virtual const char *retrieve_state() { return 0 ; }
	virtual void retrieve_state_parameter_start() {}
	virtual bool retrieve_state_parameter_done() { return true ; }
	virtual void retrieve_state_parameter_next() {}
	virtual void retrieve_state_parameter(const char **type, const char **name)
		{ *type = *name = NULL ; }
	virtual const char *retrieve_code() { return 0 ; }

	virtual void retrieve_state_graphic_center(const char **x, const char **y)
		{ *x = *y = 0 ; }
	virtual const char *retrieve_state_graphic_radius() { return 0 ; }

	virtual void retrieve_transition_start() {}
	virtual bool retrieve_transition_done() { return true ; }
	virtual void retrieve_transition_next() {}
	virtual void retrieve_transition(const char **event,
		const char **destination) { *event = *destination = 0 ; }

	virtual const char *retrieve_loop_graphic() { return 0 ; }
	virtual void retrieve_segment_vertex_start() {}
	virtual bool retrieve_segment_vertex_done() { return true ; }
	virtual void retrieve_segment_vertex_next() {}
	virtual void retrieve_segment_vertex(const char **x, const char **y)
		{ *x = *y = 0 ; }

protected:
	SMAbstractRetriever() {}
} ;



#endif /* _SMAbstractRetriever_h_ */
