/*
 *++
MODULE:

$RCSfile: SMAbstractBuilder.h,v $
$Revision: 1.5 $
$Date: 1996/10/01 04:39:31 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: SMAbstractBuilder.h,v $
Revision 1.5  1996/10/01 04:39:31  andrewm
checkpoint and revision

 * Revision 1.4  1996/09/22  01:18:43  andrewm
 * pre-alpha release
 *
 * Revision 1.3  1996/08/18  17:58:26  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/07/27  20:57:24  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/06/26  03:17:38  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _SMAbstractBuilder_h_
#define _SMAbstractBuilder_h_

/*
PRAGMAS
*/

/*
INCLUDE FILES
*/

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class SMAbstractBuilder
{
public:
	virtual void build_start() {}
	virtual void build_end() {}

	virtual void build_author(const char *author) {}
	virtual void build_revision(const char *revision) {}

	virtual void build_machine(const char *name) {}
	virtual void build_counter(const char *counter) {}
	virtual void build_prolog(const char *prolog, int line_no) {}
	virtual void build_epilog(const char *epilog, int line_no) {}
	virtual void build_error_action(const char *error_action, int line_no) {}
	virtual void build_ignore_action(const char *ignore_action, int line_no) {}
	virtual void build_initial_state(const char *initial_name) {}
	virtual void build_terminal_state(const char *terminal_name) {}
	virtual void build_default_state(const char *default_name) {}

	virtual void build_event(const char *name) {}
	virtual void build_event_parameter(const char *type, const char *name) {}

	virtual void build_state(const char *name) {}
	virtual void build_code(const char *code, int line_no) {}
	virtual void build_state_parameter(const char *type, const char *name) {}
	virtual void build_state_graphic_center(const char *x, const char *y) {}
	virtual void build_state_graphic_radius(const char *radius) {}

	virtual void build_transition(const char *event,
		const char *destination) {}
	virtual void build_loop_graphic(const char *angle) {}
	virtual void build_segment_vertex(const char *x, const char *y) {}

protected:
	SMAbstractBuilder() {}
} ;



#endif /* _SMAbstractBuilder_h_ */
