/*
 *++
MODULE:

$RCSfile: MachRetriever.h,v $
$Revision: 1.5 $
$Date: 1996/09/22 01:18:43 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MachRetriever.h,v $
Revision 1.5  1996/09/22 01:18:43  andrewm
pre-alpha release

 * Revision 1.4  1996/08/18  17:58:26  andrewm
 * checkpoint
 *
 * Revision 1.3  1996/07/27  20:57:24  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/06/26  03:17:38  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/06/15  23:53:35  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _MachRetriever_h_
#define _MachRetriever_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "SMAbstractRetriever.h"
#include "Iterator.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class MachineGroup ;
class Smachine ;
class MachEvent ;
class State ;
class Parameter ;
class Transition ;

class MachRetriever : public SMAbstractRetriever
{
public:
	MachRetriever(MachineGroup *machine_group) ;
	~MachRetriever() ;

	virtual const char *retrieve_author() ;
	virtual const char *retrieve_revision() ;

	virtual void retrieve_machine_start() ;
	virtual bool retrieve_machine_done() ;
	virtual void retrieve_machine_next() ;
	virtual const char *retrieve_machine() ;
	virtual const char *retrieve_counter() ;
	virtual const char *retrieve_prolog() ;
	virtual const char *retrieve_epilog() ;
	virtual const char *retrieve_error_action() ;
	virtual const char *retrieve_ignore_action() ;
	virtual const char *retrieve_initial_state() ;
	virtual const char *retrieve_terminal_state() ;
	virtual const char *retrieve_default_state() ;

	virtual void retrieve_event_start() ;
	virtual bool retrieve_event_done() ;
	virtual void retrieve_event_next() ;
	virtual const char *retrieve_event() ;
	virtual void retrieve_event_parameter_start() ;
	virtual bool retrieve_event_parameter_done() ;
	virtual void retrieve_event_parameter_next() ;
	virtual void retrieve_event_parameter(const char **type,
		const char **name) ;

	virtual void retrieve_state_start() ;
	virtual bool retrieve_state_done() ;
	virtual void retrieve_state_next() ;
	virtual const char *retrieve_state() ;
	virtual void retrieve_state_parameter_start() ;
	virtual bool retrieve_state_parameter_done() ;
	virtual void retrieve_state_parameter_next() ;
	virtual void retrieve_state_parameter(const char **type,
		const char **name) ;
	virtual const char *retrieve_code() ;

	virtual void retrieve_transition_start() ;
	virtual bool retrieve_transition_done() ;
	virtual void retrieve_transition_next() ;
	virtual void retrieve_transition(const char **event,
		const char **destination) ;

protected:
	MachineGroup *_machine_group ;
	Iterator<Smachine *> *_machine_iter ;
	Iterator<MachEvent * > *_event_iter ;
	Iterator<Parameter *> *_event_parameter_iter ;
	Iterator<State *> *_state_iter ;
	Iterator<Parameter *> *_state_parameter_iter ;
	Iterator<Transition *> *_transition_iter ;
} ;


#endif /* _MachRetriever_h_ */
