/*
 *++
MODULE:

$RCSfile: HIOWriter.h,v $
$Revision: 1.3 $
$Date: 1996/09/22 01:18:43 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: HIOWriter.h,v $
Revision 1.3  1996/09/22 01:18:43  andrewm
pre-alpha release

 * Revision 1.2  1996/07/15  01:21:16  andrewm
 * checkpoint again
 *
 * Revision 1.1  1996/06/15  23:53:35  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _HIOWriter_h_
#define _HIOWriter_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <String.h>
#include "HioLink.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class SMAbstractRetriever ;

class HIOWriter
{
public:
	HIOWriter(SMAbstractRetriever *retriever,
		ASSIGNMENT_LIST file_list = NULL) ;
	~HIOWriter() ;

	void retriever(SMAbstractRetriever *retriever) ;
	void retrieve() ;
	bool write_file(const char *filename) ;

private:
	SMAbstractRetriever *_retriever ;
	ASSIGNMENT_LIST _file_list ;

private:
	void write_machines(AssignmentList list) ;
	void write_events(AssignmentList list) ;
	void write_event_parameters(AssignmentList list) ;
	void write_states(AssignmentList list) ;
	void write_state_parameters(AssignmentList list) ;
	void write_state_graphic_center(AssignmentList list) ;
	void write_transitions(AssignmentList list) ;
	void write_segment_graphics(AssignmentList list) ;

private:
	static void update_value(const char *value, const char *name,
		AssignmentList list) ;
	static void update_value(const char *value, int number,
		AssignmentList list) ;
	static Assignment update_assignment(const char *assign_name,
		AssignmentList list) ;
	static Assignment update_assignment(int number,
		AssignmentList list) ;
} ;

inline HIOWriter::
HIOWriter(
	SMAbstractRetriever *retriever,
	ASSIGNMENT_LIST file_list) :
		_retriever(retriever),
		_file_list(file_list)
{
}

inline void HIOWriter::
retriever(
	SMAbstractRetriever *retriever)
{
	_retriever = retriever ;
}




#endif /* _HIOWriter_h_ */
