/*
 *++
MODULE:

$RCSfile: HIOReader.h,v $
$Revision: 1.3 $
$Date: 1996/09/22 01:45:40 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: HIOReader.h,v $
Revision 1.3  1996/09/22 01:45:40  andrewm
pre-alpha release

 * Revision 1.2  1996/07/15  01:21:16  andrewm
 * checkpoint again
 *
 * Revision 1.2  1996/07/15  01:21:16  andrewm
 * checkpoint again
 *
 * Revision 1.1  1996/06/15  23:53:35  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _HIOReader_h_
#define _HIOReader_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <String.h>

#include "HioLink.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class SMAbstractBuilder ;

class HIOReader
{
public:
	HIOReader(SMAbstractBuilder *builder) ;
	~HIOReader(void) ;

	bool read_file(const char *filename) ;
	void builder(SMAbstractBuilder *builder) ;
	void build(void) ;
	ASSIGNMENT_LIST file_list(void) const ;

private:
	SMAbstractBuilder *_builder ;
	ASSIGNMENT_LIST _file_list ;

private:
	void read_machines(AssignmentList list) ;
	void read_events(AssignmentList list) ;
	void read_event_parameters(AssignmentList list) ;
	void read_states(AssignmentList list) ;
	void read_state_parameters(AssignmentList list) ;
	void read_state_graphic_center(AssignmentList list) ;
	void read_transitions(AssignmentList list) ;
	void read_segment_graphics(AssignmentList list) ;
} ;

inline HIOReader::
HIOReader(
	SMAbstractBuilder *builder) :
		_builder(builder),
		_file_list(NULL)
{
}

inline void HIOReader::
builder(
	SMAbstractBuilder *builder)
{
	_builder = builder ;
}

inline ASSIGNMENT_LIST HIOReader::
file_list(void) const
{
	return _file_list ;
}



#endif /* _HIOReader_h_ */
