/*
 *++
MODULE:

$RCSfile: GraphicRetriever.h,v $
$Revision: 1.2 $
$Date: 1996/09/22 01:45:40 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: GraphicRetriever.h,v $
Revision 1.2  1996/09/22 01:45:40  andrewm
pre-alpha release

 * Revision 1.1  1996/06/26  03:17:38  andrewm
 * Initial revision
 *
 * Revision 1.1  1996/06/26  03:17:38  andrewm
 * Initial revision
 *
 * Revision 1.1  1996/06/15  23:53:35  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _GraphicRetriever_h_
#define _GraphicRetriever_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <X11/Xlib.h>

#include "MachRetriever.h"
#include "Iterator.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class PageGroup ;
class Page ;
class StateGraphic ;
class TransitionGraphic ;

class GraphicRetriever : public MachRetriever
{
public:
	GraphicRetriever(PageGroup *page_group) ;
	~GraphicRetriever(void) ;

	virtual const char *retrieve_machine(void) ;

	virtual const char *retrieve_state(void) ;

	virtual void retrieve_state_graphic_center(const char **x, const char **y) ;
	virtual const char *retrieve_state_graphic_radius(void) ;

	virtual void retrieve_transition(const char **event,
		const char **destination) ;

	virtual const char *retrieve_loop_graphic(void) ;
	virtual void retrieve_segment_vertex_start(void) ;
	virtual bool retrieve_segment_vertex_done(void) ;
	virtual void retrieve_segment_vertex_next(void) ;
	virtual void retrieve_segment_vertex(const char **x, const char **y) ;

private:
	PageGroup *_page_group ;
	Page *_current_page ;
	StateGraphic *_current_state_graphic ;
	TransitionGraphic *_current_transition_graphic ;
	Iterator<XPoint> *_segment_iter ;
} ;


#endif /* _GraphicRetriever_h_ */
