/*
 *++
MODULE:

$RCSfile: GraphicBuilder.cc,v $
$Revision: 1.3 $
$Date: 1997/02/08 04:37:41 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: GraphicBuilder.cc,v $
Revision 1.3  1997/02/08 04:37:41  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.2  1996/09/22 01:18:43  andrewm
pre-alpha release

// Revision 1.1  1996/06/26  03:17:38  andrewm
// Initial revision
//
// Revision 1.1  1996/06/15  23:53:35  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <iostream.h>
#include <stdlib.h>

#include "GraphicBuilder.h"
#include "PageGroup.h"
#include "Page.h"
#include "StateGraphic.h"
#include "TransitionGraphic.h"
#include "State.h"
#include "Transition.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: GraphicBuilder.cc,v $ $Revision: 1.3 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

GraphicBuilder::
GraphicBuilder(void) :
	_current_state_graphic(0),
	_current_transition_graphic(0)
{
}

void GraphicBuilder::
build_state(
	const char *name)
{
	_current_state_graphic = new StateGraphic(name) ;
	_current_machine->add_state(_current_state_graphic) ;
	_current_state = _current_state_graphic ;
}

void GraphicBuilder::
build_state_graphic_center(
	const char *x,
	const char *y)
{
	float fx = strtod(x, NULL) ;
	float fy = strtod(y, NULL) ;
	_current_state_graphic->circle().center() = Point(fx, fy) ;
}

void GraphicBuilder::
build_state_graphic_radius(
	const char *radius)
{
	float frad = strtod(radius, NULL) ;
	_current_state_graphic->circle().radius() = frad ;
}

void GraphicBuilder::
build_transition(
	const char *event,
	const char *destination)
{
	MachBuilder::build_transition(event, destination) ;

	State *dest = _current_transition->destination() ;
	if (dest->is_std_state())
	{
		_current_transition_graphic = NULL ;
	}
	else
	{
		StateGraphic *dest_graphic = _current_page->find_state_graphic(dest) ;
		_current_transition_graphic =
			_current_state_graphic->add_transition_graphic(
			_current_transition, dest_graphic) ;
	}
}

void GraphicBuilder::
build_loop_graphic(
	const char *angle)
{
	if (angle && _current_transition_graphic)
	{
		int attach_angle = strtol(angle, NULL, 0) ;
		_current_transition_graphic->attach_angle(attach_angle) ;
	}
}

void GraphicBuilder::
build_segment_vertex(
	const char *x,
	const char *y)
{
	if (x && y && _current_transition_graphic)
	{
		int ix = strtol(x, NULL, 0) ;
		int iy = strtol(y, NULL, 0) ;
		_current_transition_graphic->append_segment(ix, iy) ;
	}
}
