/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Parameter.h,v $
$Revision: 1.10 $
$Date: 1997/07/02 04:45:12 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Parameter.h,v $
Revision 1.10  1997/07/02 04:45:12  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.9  1997/05/31 21:12:42  andrewm
Checkpoint.  Things are working well.

Revision 1.8  1997/05/15 04:14:45  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.7  1997/04/24 03:20:48  andrewm
Checkpoint.  All features in.  Starting test cycle.

Revision 1.6  1997/03/04 06:32:55  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.5  1996/12/26 05:55:24  andrewm
Checkpoint, the compiler is working again.

Revision 1.4  1996/12/24 05:20:11  andrewm
Checkpoint.

Revision 1.3  1996/09/22 01:18:22  andrewm
pre-alpha release

 * Revision 1.2  1996/07/15  01:20:40  andrewm
 * checkpoint again
 *
 * Revision 1.1  1996/06/26  03:14:43  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _Parameter_h_
#define _Parameter_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/

#include "Chio.h"
#include "MachineVisitor.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS FORWARD REFERENCES
*/
class MachEvent ;
class State ;

/*
CLASS DEFINITIONS
*/

class Parameter
{
	friend bool operator ==(const Parameter& p1, const Parameter& p2) ;
	friend ostream& operator <<(ostream& stream, Parameter& parameter) ;

public:
	virtual ~Parameter() ;
	bool modified() const { return _modified ; }
	void modified(bool new_modified) { _modified = new_modified ; }
	const ChioTerm& type() const { return _type ; }
	void type(const ChioTerm& new_type) {
		_type = new_type ; _modified = true ;
	}
	const ChioTerm& name() const { return _name ; }
	void name(const ChioTerm& new_name) {
		_name = new_name ; _modified = true ;
	}

	virtual void orphan() = 0 ;
	virtual void sync() = 0 ;
	virtual ChioListIter find_place() = 0 ;

	void accept_visitor(MachineVisitor& visitor) { visitor.visit(this) ; }

protected:
	Parameter(
		ChioList& parent_list,
		ChioListIter position,
		const ChioTerm& type,
		const ChioTerm& name) ;
	Parameter(ChioListIter place) ;

protected:
	bool _modified ;
	ChioTerm _type ;
	ChioTerm _name ;

protected:
	static const char _type_name[] ;
	static const char _name_name[] ;
} ;

class EventParameter :
	public Parameter
{
public:
	EventParameter(
		MachEvent *parent,
		ChioListIter position,
		const ChioTerm& type,
		const ChioTerm& name) ;
	EventParameter(MachEvent *parent, ChioListIter place) ;
	virtual ~EventParameter() ;

	virtual void orphan() { _parent = 0 ; }
	virtual void sync() ;
	virtual ChioListIter find_place() ;

private:
	MachEvent *_parent ;
} ;

class StateParameter :
	public Parameter
{
public:
	StateParameter(
		State *parent,
		ChioListIter position,
		const ChioTerm& type,
		const ChioTerm& name) ;
	StateParameter(State *parent, ChioListIter place) ;
	virtual ~StateParameter() ;

	virtual void orphan() { _parent = 0 ; }
	virtual void sync() ;
	virtual ChioListIter find_place() ;

private:
	State *_parent ;
} ;


#endif /* _Parameter_h_ */
