/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Parameter.cc,v $
$Revision: 1.8 $
$Date: 1997/07/02 04:45:12 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Parameter.cc,v $
Revision 1.8  1997/07/02 04:45:12  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.7  1997/05/31 21:12:42  andrewm
Checkpoint.  Things are working well.

Revision 1.6  1997/05/20 05:15:33  andrewm
Checkpoint.  Improved the structure of the "State" class and this
had quite some ripple effects.  However, now there is an abstract
class "State" with two concrete classes "PseudoState" to represent
error and ignore and "RealState" to represent the user specified
states.  Also improved the text display of event names on the transitions.

Revision 1.5  1997/05/15 04:14:45  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.4  1997/04/24 03:20:48  andrewm
Checkpoint.  All features in.  Starting test cycle.

Revision 1.3  1997/03/04 06:32:54  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.2  1996/12/26 05:55:24  andrewm
Checkpoint, the compiler is working again.

Revision 1.1  1996/12/24 05:20:11  andrewm
Checkpoint.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Parameter.h"
#include "MachEvent.h"
#include "State.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: Parameter.cc,v $ $Revision: 1.8 $" ;

/*
STATIC MEMBER DEFINITIONS
*/
const char Parameter::_type_name[] = "type" ;
const char Parameter::_name_name[] = "name" ;

/*
FUNCTION DEFINITIONS
*/

Parameter::
Parameter(
	ChioList& parent_list,
	ChioListIter position,
	const ChioTerm& type,
	const ChioTerm& name) :
		_modified(true),
		_type(type),
		_name(name)
{
		// Create the map that contains the type and name information.
	ChioMap::pair_iterator_bool result ;
	ChioMap m ;
	result = m.insert(ChioAssignment(_type_name, _type)) ;
	assert(result.second == true) ;
	result = m.insert(ChioAssignment(_name_name, _name)) ;
	assert(result.second == true) ;
		// Add the type/name map to the parent map.
	parent_list.insert(position, m) ;
}

Parameter::
Parameter(
	ChioListIter place) :
		_modified(false)
{
	ChioMap& file_def = *place ;
	_type = file_def[_type_name] ;
	_name = file_def[_name_name] ;
}

Parameter::
~Parameter()
{
}

bool
operator ==(
	const Parameter& p1,
	const Parameter& p2)
{
	return p1._type == p2._type && p1._name == p2._name ;
}

ostream&
operator <<(
	ostream& stream,
	Parameter& parameter)
{
	return stream << parameter._type.c_str() << ' ' << parameter._name.c_str() ;
}

EventParameter::
EventParameter(
	MachEvent *parent,
	ChioListIter position,
	const ChioTerm& type,
	const ChioTerm& name) :
		Parameter(parent->parameters(), position, type, name),
		_parent(parent)
{
}

EventParameter::
EventParameter(
	MachEvent *parent,
	ChioListIter place) :
		Parameter(place),
		_parent(parent)
{
}

EventParameter::
~EventParameter()
{
	if (_parent)
	{
		_parent->parameters().erase(find_place()) ;
		_parent->remove_parameter(this) ;
	}
}

void EventParameter::
sync()
{
	ChioMap& m = *find_place() ;
	m[_type_name] = _type ;
	m[_name_name] = _name ;
}

ChioListIter EventParameter::
find_place()
{
	ChioList& pm_list = _parent->parameters() ;
	ChioListIter pm_iter = pm_list.begin() ;
	MachEvent::ParameterList& p_list = _parent->parameter_list() ;
	for (MachEvent::ParameterListIter p_iter = p_list.begin() ;
		p_iter != p_list.end() ; ++p_iter, ++pm_iter)
	{
		assert(pm_iter != pm_list.end()) ;
		if (*p_iter == this)
			break ;
	}

	assert(pm_iter != pm_list.end()) ;
	return pm_iter ;
}

StateParameter::
StateParameter(
	State *parent,
	ChioListIter position,
	const ChioTerm& type,
	const ChioTerm& name) :
		Parameter(parent->parameters(), position, type, name),
		_parent(parent)
{
}

StateParameter::
StateParameter(
	State *parent,
	ChioListIter place) :
		Parameter(place),
		_parent(parent)
{
}

StateParameter::
~StateParameter()
{
	if (_parent)
	{
		_parent->parameters().erase(find_place()) ;
		_parent->remove_parameter(this) ;
	}
}

void StateParameter::
sync()
{
	ChioMap& m = *find_place() ;
	m[_type_name] = _type ;
	m[_name_name] = _name ;
}

ChioListIter StateParameter::
find_place()
{
	ChioList& pm_list = _parent->parameters() ;
	ChioListIter pm_iter = pm_list.begin() ;
	const State::ParameterList& p_list = _parent->parameter_list() ;
	for (State::ParameterListConstIter p_iter = p_list.begin() ;
		p_iter != p_list.end() ; ++p_iter, ++pm_iter)
	{
		assert(pm_iter != pm_list.end()) ;
		if (*p_iter == this)
			break ;
	}

	assert(pm_iter != pm_list.end()) ;
	return pm_iter ;
}
