/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:
MachineGroup.h -- declarations for a state machine set

$RCSfile: MachineGroup.h,v $
$Revision: 1.13 $
$Date: 1997/07/02 04:45:12 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MachineGroup.h,v $
Revision 1.13  1997/07/02 04:45:12  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.12  1997/05/15 04:14:45  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.11  1997/04/24 03:20:47  andrewm
Checkpoint.  All features in.  Starting test cycle.

Revision 1.10  1997/03/30 02:07:30  andrewm
Checkpoint.  Things working well. About to change the way
machines are stored in the backing file.

Revision 1.9  1997/03/04 06:32:54  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.8  1997/02/08 04:37:40  andrewm
Checkpoint before returning to work on the GUI portion.

Revision 1.7  1996/12/24 05:20:10  andrewm
Checkpoint.

Revision 1.6  1996/10/01 04:39:14  andrewm
checkpoint and revision

 * Revision 1.5  1996/09/22  01:45:26  andrewm
 * pre-alpha release
 *
 * Revision 1.4  1996/08/18  17:57:45  andrewm
 * checkpoint
 *
 * Revision 1.4  1996/08/18  17:57:45  andrewm
 * checkpoint
 *
 * Revision 1.3  1996/07/15  01:20:40  andrewm
 * checkpoint again
 *
 * Revision 1.2  1996/06/26  03:14:43  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/06/15  23:53:13  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _MachineGroup_h_
#define _MachineGroup_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <string>
#include <list>
#include "Chio.h"
#include "Observer.h"
#include "MachineVisitor.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Smachine ;


class MachineGroup :
	public Subject
{
public:
	typedef list<Smachine *> SmachineList ;
	typedef list<Smachine *>::iterator SmachineListIter ;
	typedef list<Smachine *>::const_iterator SmachineListConstIter ;

public:
		// constructors and destructors
	MachineGroup(const char *author = NULL, const char *revision = NULL) ;
	MachineGroup(const ChioMap& file_map) ;
	~MachineGroup() ;

		// accessors
	bool modified() const ;
	void modified(bool new_modified) ;
	void sync() ;
	const ChioTerm& author() const { return _author ; }
	void author(const ChioTerm& new_author) ;
	const ChioTerm& revision() const { return _revision ; }
	void revision(const ChioTerm& new_revision) ;
	const ChioTerm& group_prolog() const { return _group_prolog ; }
	void group_prolog(const ChioTerm& new_group_prolog) ;
	const ChioTerm& group_epilog() const { return _group_epilog ; }
	void group_epilog(const ChioTerm& new_group_epilog) ;
	ChioMap& file_map() { sync() ; return _file_map ; }
	ChioList& state_machines() ;

	Smachine *find_machine(const ChioTerm& name) const ;
	Smachine *add_machine(const ChioTerm& name) ;
	Smachine *add_machine() ;
	Smachine *insert_machine(Smachine *current, const ChioTerm& name) ;
	Smachine *insert_machine(Smachine *current) ;
	void remove_machine(Smachine *machine) ;
	SmachineList& machine_list() { return _machine_list ; }

	void accept_visitor(MachineVisitor& visitor) { visitor.visit(this) ; }

private:
	bool _modified ;
	ChioTerm _author ;
	ChioTerm _revision ;
	ChioTerm _group_prolog ;
	ChioTerm _group_epilog ;
	SmachineList _machine_list ;
	ChioMap _file_map ;

private:
	ChioTerm new_machine_name() ;
	MachineGroup& operator =(const MachineGroup &mg) ; // no assignments

private:
	static const char _author_name[] ;
	static const char _revision_name[] ;
	static const char _group_prolog_name[] ;
	static const char _group_epilog_name[] ;
	static const char _state_machines_name[] ;
} ;


#endif /* _MachineGroup_h_ */
