/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: UnspecTransitionDialog.h,v $
$Revision: 1.3 $
$Date: 1997/07/02 04:45:11 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: UnspecTransitionDialog.h,v $
Revision 1.3  1997/07/02 04:45:11  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.2  1997/06/06 04:34:27  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.1  1997/04/16 04:06:15  andrewm
Checkpoint, as last major dialog is in.

Revision 1.3  1997/02/23 23:44:09  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.2  1996/10/01 04:40:29  andrewm
checkpoint and revision

 * Revision 1.1  1996/09/22  01:20:08  andrewm
 * pre-alpha release
 *
 *--
 */
#ifndef _UnspecTransitionDialog_h_
#define _UnspecTransitionDialog_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "UIComponent.h"
#include "Observer.h"

#include <vector>

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class State ;
class MachEvent ;
class Transition ;

class UnspecTransitionDialog :
	public UIComponent,
	public Observer
{
public:
	UnspecTransitionDialog(const char *name, UIComponent *parent) ;
	~UnspecTransitionDialog() ;
	virtual const char *className() const { return "UnspecTransitionDialog" ; }

	virtual void update(const Subject *subject) ;
	virtual void subject_deleted(Subject *subject) ;

	void state(State *state) ;

private:
	void apply() ;
	void reset() ;
	void help() ;
	void build_event_list() ;
	void clear_event_list() ;
	void clear_all_toggles() ;
		// no assignments
	UnspecTransitionDialog& operator =(const UnspecTransitionDialog&) ;

private:
	enum StateSpec
	{
		DefaultState,
		ErrorState,
		IgnoreState
	} ;

	Widget _scrolled_list ;
	Widget _default_toggle ;
	Widget _error_toggle ;
	Widget _ignore_toggle ;
	State *_state ;
	StateSpec _selected_dest ;
	vector<MachEvent *> _event_list ;
	MachEvent *_selected_event ;
	Transition *_selected_trans ;

private:
	static void applyCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void resetCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void helpCallback(Widget w, XtPointer closure, XtPointer call_data) ;
	static void listCallback(Widget w, XtPointer closure, XtPointer call_data) ;
	static void defaultCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void errorCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void ignoreCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
} ;


#endif /* _UnspecTransitionDialog_h_ */
