/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: UnspecTransitionDialog.cc,v $
$Revision: 1.6 $
$Date: 1997/07/02 04:45:11 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: UnspecTransitionDialog.cc,v $
Revision 1.6  1997/07/02 04:45:11  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.5  1997/06/21 02:21:33  andrewm
Checkpoint.  PostScript generator going well. A lot of small tweeks
all over to accomplish this.

Revision 1.4  1997/06/06 04:34:27  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.3  1997/05/20 05:15:31  andrewm
Checkpoint.  Improved the structure of the "State" class and this
had quite some ripple effects.  However, now there is an abstract
class "State" with two concrete classes "PseudoState" to represent
error and ignore and "RealState" to represent the user specified
states.  Also improved the text display of event names on the transitions.

Revision 1.2  1997/05/15 04:14:44  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.1  1997/04/16 04:06:15  andrewm
Checkpoint, as last major dialog is in.

Revision 1.3  1997/02/23 23:44:09  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.2  1996/10/01 04:40:29  andrewm
checkpoint and revision

// Revision 1.1  1996/09/22  01:20:08  andrewm
// pre-alpha release
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "UnspecTransitionDialog.h"
#include "Smachine.h"
#include "State.h"
#include "MachEvent.h"
#include "Transition.h"

#include <assert.h>
#include <algorithm>

#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/ToggleB.h>
#include <Xm/Separator.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <XmCxx/CxxXmString.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: UnspecTransitionDialog.cc,v $ $Revision: 1.6 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

UnspecTransitionDialog::
UnspecTransitionDialog(
	const char *name,
	UIComponent *parent) :
		_state(NULL),
		_selected_dest(ErrorState),
		_selected_trans(NULL)
{
	Arg args[12] ;
	Cardinal n = 0 ;

	_widget = XmCreateForm(parent->widget(), (char *)name, args, n) ;
	installDestroyHandler() ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget list_form = XmCreateForm(_widget, "ListForm", args, n) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	Widget list_label = XmCreateLabel(list_form, "ListLabel", args, n) ;
	XtManageChild(list_label) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, list_label) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNvisibleItemCount, 4) ; n++ ;
	XtSetArg(args[n], XmNselectionPolicy, XmBROWSE_SELECT) ; n++ ;
	_scrolled_list = XmCreateScrolledList(list_form, "ScrolledList", args, n) ;
	XtManageChild(_scrolled_list) ;
	XtAddCallback(_scrolled_list, XmNbrowseSelectionCallback, listCallback,
		(XtPointer)this) ;
	XtAddCallback(_scrolled_list, XmNdefaultActionCallback, listCallback,
		(XtPointer)this) ;

	XtManageChild(list_form) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, list_form) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
	Widget radio_box = XmCreateRadioBox(_widget, "RadioBox", args, n) ;

	_default_toggle = XmCreateToggleButton(radio_box, "Default", NULL, 0) ;
	XtManageChild(_default_toggle) ;
	XtAddCallback(_default_toggle, XmNvalueChangedCallback, defaultCallback,
		(XtPointer)this) ;
	_error_toggle = XmCreateToggleButton(radio_box, "Error", NULL, 0) ;
	XtManageChild(_error_toggle) ;
	XtAddCallback(_error_toggle, XmNvalueChangedCallback, errorCallback,
		(XtPointer)this) ;
	_ignore_toggle = XmCreateToggleButton(radio_box, "Ignore", NULL, 0) ;
	XtManageChild(_ignore_toggle) ;
	XtAddCallback(_ignore_toggle, XmNvalueChangedCallback, ignoreCallback,
		(XtPointer)this) ;

	XtManageChild(radio_box) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, radio_box) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget sep = XmCreateSeparator(_widget, "Sep", args, n) ;
	XtManageChild(sep) ;

		// Positioning of buttons in the form
	const int nbuttons = 3 ;
	const int nspaces = nbuttons - 1 ;
	const int button_size = 3 ;
	const int space_size = 1 ;
	const int base = nbuttons * button_size + nspaces * space_size  ;
	int current_pos = 0 ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, sep) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNhorizontalSpacing, 10) ; n++ ;
	XtSetArg(args[n], XmNverticalSpacing, 10) ; n++ ;
	XtSetArg(args[n], XmNfractionBase, base) ; n++ ;
	Widget button_form = XmCreateForm(_widget, "ButtonForm", args, n) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNleftPosition, current_pos) ; n++ ;
	current_pos += button_size ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNrightPosition, current_pos) ; n++ ;
	current_pos += space_size ;
	XtSetArg(args[n], XmNshowAsDefault, True) ; n++ ;
	XtSetArg(args[n], XmNdefaultButtonShadowThickness, 1) ; n++ ;
	XtSetArg(args[n], XmNmarginTop, 2) ; n++ ;
	XtSetArg(args[n], XmNmarginBottom, 2) ; n++ ;
	Widget button = XmCreatePushButton(button_form, "Apply", args, n) ;
	XtAddCallback(button, XmNactivateCallback, applyCallback, (XtPointer)this) ;
	XtManageChild(button) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNleftPosition, current_pos) ; n++ ;
	current_pos += button_size ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNrightPosition, current_pos) ; n++ ;
	current_pos += space_size ;
	XtSetArg(args[n], XmNshowAsDefault, False) ; n++ ;
	XtSetArg(args[n], XmNdefaultButtonShadowThickness, 1) ; n++ ;
	XtSetArg(args[n], XmNmarginTop, 2) ; n++ ;
	XtSetArg(args[n], XmNmarginBottom, 2) ; n++ ;
	button = XmCreatePushButton(button_form, "Reset", args, n) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, resetCallback,
		(XtPointer)this) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNleftPosition, current_pos) ; n++ ;
	current_pos += button_size ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNrightPosition, current_pos) ; n++ ;
	current_pos += space_size ;
	XtSetArg(args[n], XmNshowAsDefault, False) ; n++ ;
	XtSetArg(args[n], XmNdefaultButtonShadowThickness, 1) ; n++ ;
	XtSetArg(args[n], XmNmarginTop, 2) ; n++ ;
	XtSetArg(args[n], XmNmarginBottom, 2) ; n++ ;
	button = XmCreatePushButton(button_form, "Help", args, n) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, helpCallback, (XtPointer)this) ;
	XtSetSensitive(button, False) ; // for now no help

	XtManageChild(button_form) ;
}

UnspecTransitionDialog::
~UnspecTransitionDialog()
{
	if (_state)
		_state->detach(this) ;
}

void UnspecTransitionDialog::
update(
	const Subject *subject)
{
	clear_event_list() ;
	build_event_list() ;
}

void UnspecTransitionDialog::
subject_deleted(
	Subject *subject)
{
	if (subject == _state)
	{
		Smachine *parent = _state->parent() ;
		if (parent) parent->detach(this) ;
	}
	_state = NULL ;
	update(_state) ;
}

void UnspecTransitionDialog::
state(
	State *state)
{
	State *old_state = _state ;
	_state = state ;
	if (old_state != _state)
	{
		if (old_state)
		{
			old_state->parent()->detach(this) ;
			old_state->detach(this) ;
		}
		if (_state)
		{
			_state->parent()->attach(this) ;
			_state->attach(this) ;
		}
	}
	update(_state) ;
}

void UnspecTransitionDialog::
apply()
{
	State *dest = NULL ;
	if (_selected_trans)
	{
		switch (_selected_dest)
		{
		case DefaultState:
			delete _selected_trans ;
			_selected_trans = NULL ;
			break ;

		case ErrorState:
			dest = _state->parent()->find_state("error") ;
			assert(dest != NULL) ;
			delete _selected_trans ;
			_selected_trans = _state->add_pseudo_transition(_selected_event,
				dest) ;
			break ;

		case IgnoreState:
			dest = _state->parent()->find_state("ignore") ;
			assert(dest != NULL) ;
			delete _selected_trans ;
			_selected_trans = _state->add_pseudo_transition(_selected_event,
				dest) ;
			break ;

		default:
			cerr << "Unknown selected state " << _selected_dest << endl ;
		}
	}
	else
	{
		switch (_selected_dest)
		{
		case DefaultState:
			break ;

		case ErrorState:
			dest = _state->parent()->find_state("error") ;
			assert(dest) ;
			_selected_trans = _state->add_pseudo_transition(_selected_event,
				dest) ;
			assert(_selected_trans) ;
			break ;

		case IgnoreState:
			dest = _state->parent()->find_state("ignore") ;
			assert(dest) ;
			_selected_trans = _state->add_pseudo_transition(_selected_event,
				dest) ;
			assert(_selected_trans) ;
			break ;

		default:
			cerr << "Unknown selected state " << _selected_dest << endl ;
		}
	}
}

void UnspecTransitionDialog::
reset()
{
	if (_selected_event)
	{
		_selected_trans = _state->find_transition(_selected_event) ;
		if (_selected_trans)
		{
			string dest_name(_selected_trans->destination()->name().c_str()) ;
			if (dest_name == "error")
				XmToggleButtonSetState(_error_toggle, True, True) ;
			else if (dest_name == "ignore")
				XmToggleButtonSetState(_ignore_toggle, True, True) ;
			else
				clear_all_toggles() ;
		}
		else
		{
			XmToggleButtonSetState(_default_toggle, True, True) ;
		}
	}
	else
		clear_all_toggles() ;
}

void UnspecTransitionDialog::
help()
{
}

void UnspecTransitionDialog::
build_event_list()
{
	if (!_state)
		return ;

	Smachine *parent = _state->parent() ;
	if (!parent)
		return ;

	class UnspecEventSelector
	{
	public:
		UnspecEventSelector(State *state) : _state(state) {}
		bool operator ()(MachEvent *event) {
			Transition *trans = _state->find_transition(event) ;
			return !(trans == NULL || trans->destination()->is_pseudo_state()) ;
		}
	private:
		State *_state ;
	} ;

	Smachine::MachEventList& events = parent->event_list() ;
	UnspecEventSelector select(_state) ;
	remove_copy_if(events.begin(), events.end(), back_inserter(_event_list),
		select) ;

	for (vector<MachEvent *>::const_iterator event_iter = _event_list.begin() ;
		event_iter != _event_list.end() ; ++event_iter)
	{
		XmListAddItemUnselected(_scrolled_list,
			XmCxxString((*event_iter)->name().c_str()), 0) ;
	}
}

void UnspecTransitionDialog::
clear_event_list()
{
	_event_list.erase(_event_list.begin(), _event_list.end()) ;
	XmListDeleteAllItems(_scrolled_list) ;
	clear_all_toggles() ;
	_selected_event = NULL ;
	_selected_trans = NULL ;
}

void UnspecTransitionDialog::
clear_all_toggles()
{
	XmToggleButtonSetState(_default_toggle, False, True) ;
	XmToggleButtonSetState(_error_toggle, False, True) ;
	XmToggleButtonSetState(_ignore_toggle, False, True) ;
}

void UnspecTransitionDialog::
applyCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	UnspecTransitionDialog *unspec_dialog = (UnspecTransitionDialog *)closure ;
	unspec_dialog->apply() ;
}

void UnspecTransitionDialog::
resetCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	UnspecTransitionDialog *unspec_dialog = (UnspecTransitionDialog *)closure ;
	unspec_dialog->reset() ;
}

void UnspecTransitionDialog::
helpCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	UnspecTransitionDialog *unspec_dialog = (UnspecTransitionDialog *)closure ;
	unspec_dialog->help() ;
}

void UnspecTransitionDialog::
listCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	UnspecTransitionDialog *unspec_dialog = (UnspecTransitionDialog *)closure ;
	XmListCallbackStruct *cbs = (XmListCallbackStruct *)call_data ;

	int item_offset = cbs->item_position - 1 ;
	assert(item_offset >= 0) ;
	MachEvent *selected_event =
		unspec_dialog->_selected_event =
		unspec_dialog->_event_list[item_offset] ;
	Transition *selected_trans = unspec_dialog->_selected_trans =
		unspec_dialog->_state->find_transition(selected_event) ;
	if (selected_trans == NULL)
		XmToggleButtonSetState(unspec_dialog->_default_toggle, True, True) ;
	else
	{
		string dest_name(selected_trans->destination()->name().c_str()) ;
		if (dest_name == "error")
			XmToggleButtonSetState(unspec_dialog->_error_toggle, True, True) ;
		else if (dest_name == "ignore")
			XmToggleButtonSetState(unspec_dialog->_ignore_toggle, True, True) ;
		else
			cerr << "Unexpected destination name \"" << dest_name << "\""
				<< endl ;
	}
}

void UnspecTransitionDialog::
defaultCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	UnspecTransitionDialog *unspec_dialog = (UnspecTransitionDialog *)closure ;
	XmToggleButtonCallbackStruct *cbs =
		(XmToggleButtonCallbackStruct *)call_data ;
	if (cbs->set == XmSET)
		unspec_dialog->_selected_dest = DefaultState ;
}

void UnspecTransitionDialog::
errorCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	UnspecTransitionDialog *unspec_dialog = (UnspecTransitionDialog *)closure ;
	XmToggleButtonCallbackStruct *cbs =
		(XmToggleButtonCallbackStruct *)call_data ;
	if (cbs->set == XmSET)
		unspec_dialog->_selected_dest = ErrorState ;
}

void UnspecTransitionDialog::
ignoreCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	UnspecTransitionDialog *unspec_dialog = (UnspecTransitionDialog *)closure ;
	XmToggleButtonCallbackStruct *cbs =
		(XmToggleButtonCallbackStruct *)call_data ;
	if (cbs->set == XmSET)
		unspec_dialog->_selected_dest = IgnoreState ;
}
