/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: SmachineDialogDirector.h,v $
$Revision: 1.4 $
$Date: 1997/07/02 04:45:10 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: SmachineDialogDirector.h,v $
Revision 1.4  1997/07/02 04:45:10  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.3  1997/06/06 04:34:26  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.2  1997/05/20 05:15:30  andrewm
Checkpoint.  Improved the structure of the "State" class and this
had quite some ripple effects.  However, now there is an abstract
class "State" with two concrete classes "PseudoState" to represent
error and ignore and "RealState" to represent the user specified
states.  Also improved the text display of event names on the transitions.

Revision 1.1  1997/04/08 04:34:31  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

 *--
 */
#ifndef _SmachineDialogDirector_h_
#define _SmachineDialogDirector_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "DialogDirector.h"
#include "Observer.h"

#include <X11/Intrinsic.h>
#include <string>

/*
MACRO DEFINITIONS
*/

/*
CLASS FORWARD REFERENCES
*/

/*
CLASS DEFINITIONS
*/

class GsmDocument ;
class Smachine ;
class State ;
class DialogForm ;
class MenuButton ;
class TextEditor ;

class SmachineDialogDirector :
	public DialogDirector,
	public Observer
{
public:
	SmachineDialogDirector(const char *name, UIComponent *parent,
		GsmDocument& document) ;
	~SmachineDialogDirector() ;

	virtual void show_dialog() ;
	virtual void dismiss_dialog() ;

	virtual void update(const Subject *subject) ;
	virtual void subject_deleted(Subject *subject) ;

	bool modified() const ;
	void modified(bool new_modified) ;

protected:
	void set_name() ;
	bool set_initial_state() ;
	bool set_terminal_state() ;
	bool set_default_state() ;
	void set_error_code() ;
	void set_ignore_code() ;
	void set_prolog() ;
	void set_epilog() ;
	void edit_error_code() ;
	void edit_ignore_code() ;
	void edit_prolog() ;
	void edit_epilog() ;

private:
	void update_document() ;
	void update_machine() ;
	void update_initial_state() ;
	void update_terminal_state() ;
	void update_default_state() ;
	void update_error_state() ;
	void update_ignore_state() ;
	void detach_states() ;

private:
	static void name_entry_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static void initial_state_entry_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static void terminal_state_entry_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static void default_state_entry_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;

private:
	GsmDocument& _document ;
	Smachine *_machine ;
	State *_initial_state ;
	State *_terminal_state ;
	State *_default_state ;
	State *_error_state ;
	State *_ignore_state ;
	DialogForm *_form ;
	Widget _name_entry ;
	Widget _initial_state_entry ;
	Widget _terminal_state_entry ;
	Widget _default_state_entry ;
	MenuButton *_error_code_button ;
	TextEditor *_error_code_editor ;
	MenuButton *_ignore_code_button ;
	TextEditor *_ignore_code_editor ;
	MenuButton *_prolog_button ;
	TextEditor *_prolog_editor ;
	MenuButton *_epilog_button ;
	TextEditor *_epilog_editor ;
} ;


#endif /* _SmachineDialogDirector_h_ */
