/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: SaveDialogDirector.cc,v $
$Revision: 1.3 $
$Date: 1997/07/02 04:45:10 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: SaveDialogDirector.cc,v $
Revision 1.3  1997/07/02 04:45:10  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.2  1997/03/30 02:07:30  andrewm
Checkpoint.  Things working well. About to change the way
machines are stored in the backing file.

Revision 1.1  1997/03/04 06:34:41  andrewm
New director objects used for more complex dialogs.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "SaveDialogDirector.h"
#include "UIComponent.h"
#include "Command.h"
#include "QuestionDialog.h"
#include "Document.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/
typedef SimpleCommand<SaveDialogDirector> SDD_Command ;

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: SaveDialogDirector.cc,v $ $Revision: 1.3 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

SaveDialogDirector::
SaveDialogDirector(
	UIComponent *parent,
	Document& document) :
		_document(document),
		_question(new QuestionDialog("saveDialog", parent))
{
	_question->ok_command(
		new SDD_Command(this, SaveDialogDirector::save_yes)) ;
	_question->cancel_command(
		new SDD_Command(this, SaveDialogDirector::save_no)) ;
}

SaveDialogDirector::
~SaveDialogDirector()
{
	delete _question ;
}

void SaveDialogDirector::
show_dialog()
{
	if (_document.modified())
		_question->manage() ;
}

void SaveDialogDirector::
save_yes()
{
	_document.save() ;
}

void SaveDialogDirector::
save_no()
{
}
