/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: ParameterDialog.h,v $
$Revision: 1.4 $
$Date: 1997/07/02 04:45:09 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: ParameterDialog.h,v $
Revision 1.4  1997/07/02 04:45:09  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.3  1997/06/06 04:34:26  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.2  1997/04/12 21:15:00  andrewm
Checkpoint after adding the event dialog.

Revision 1.1  1997/04/08 04:34:30  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

Revision 1.3  1997/02/23 23:44:07  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.2  1996/10/01 04:40:29  andrewm
checkpoint and revision

 * Revision 1.1  1996/09/22  01:20:08  andrewm
 * pre-alpha release
 *
 *--
 */
#ifndef _ParameterDialog_h_
#define _ParameterDialog_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "TwoPartSelectionBox.h"
#include "Observer.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class State ;
class MachEvent ;
class Parameter ;

class ParameterDialog :
	public TwoPartSelectionBox
{
public:
	ParameterDialog(const char *name, UIComponent *parent) ;
	virtual const char *className() const { return "ParameterDialog" ; }

	virtual void add_parameter() = 0 ;
	virtual void change_parameter() = 0 ;
	virtual void delete_parameter() = 0 ;

	void show_parameter(Parameter *param) ;
} ;

class StateParameterDialog :
	public ParameterDialog,
	public Observer
{
public:
	StateParameterDialog(const char *name, UIComponent *parent) ;
	virtual const char *className() const { return "StateParameterDialog" ; }

	virtual void add_parameter() ;
	virtual void change_parameter() ;
	virtual void delete_parameter() ;

	virtual void update(const Subject *subject) ;
	virtual void subject_deleted(Subject *subject) ;

	void state(State *new_state) ;

private:
	State *_state ;
} ;

class EventParameterDialog:
	public ParameterDialog,
	public Observer
{
public:
	EventParameterDialog(const char *name, UIComponent *parent) ;
	virtual const char *className() const { return "EventParameterDialog" ; }

	virtual void add_parameter() ;
	virtual void change_parameter() ;
	virtual void delete_parameter() ;

	virtual void update(const Subject *subject) ;
	virtual void subject_deleted(Subject *subject) ;

	void event(MachEvent *new_event) ;

private:
	MachEvent *_event ;
} ;


#endif /* _ParameterDialog_h_ */
