/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: MachineGroupDialogDirector.cc,v $
$Revision: 1.6 $
$Date: 1997/07/02 04:45:08 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MachineGroupDialogDirector.cc,v $
Revision 1.6  1997/07/02 04:45:08  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.5  1997/06/06 04:34:25  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.4  1997/05/31 21:12:41  andrewm
Checkpoint.  Things are working well.

Revision 1.3  1997/05/15 04:14:43  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.2  1997/04/08 04:34:30  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

Revision 1.1  1997/03/30 02:07:28  andrewm
Checkpoint.  Things working well. About to change the way
machines are stored in the backing file.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "GsmDocument.h"
#include "Application.h"
#include "Command.h"
#include "MachineGroup.h"
#include "DialogForm.h"
#include "MenuButton.h"
#include "TextEditor.h"
#include "MachineGroupDialogDirector.h"

#include <strstream.h>
#include <time.h>
#include <Xm/Separator.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include <XmCxx/CxxXmString.h>


/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/
typedef SimpleCommand<MachineGroupDialogDirector> MGDD_Command ;

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: MachineGroupDialogDirector.cc,v $ $Revision: 1.6 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

MachineGroupDialogDirector::
MachineGroupDialogDirector(
	const char *name,
	UIComponent *parent,
	GsmDocument& document) :
		_document(document),
		_group(document.machine_group()),
		_form(new DialogForm(name, parent)),
		_prolog_button(NULL),
		_prolog_editor(NULL),
		_epilog_button(NULL),
		_epilog_editor(NULL)
{
	Arg args[10] ;
	Cardinal n ;

	n = 0 ;
	XtSetArg(args[n], XmNverticalSpacing, 10) ; n++ ;
	XtSetArg(args[n], XmNhorizontalSpacing, 10) ; n++ ;
	XtSetArg(args[n], XmNautoUnmanage, False) ; n++ ;
	_form->setValues(args, n) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget name_display = XmCreateFrame(_form->widget(), "name_frame",
		args, n) ;
	n = 0 ;
	XtSetArg(args[n], XmNframeChildType, XmFRAME_TITLE_CHILD) ; n++ ;
	Widget frame_title = XmCreateLabel(name_display, "file_info", args, n) ;
	XtManageChild(frame_title) ;
	n = 0 ;
	XtSetArg(args[n], XmNframeChildType, XmFRAME_WORKAREA_CHILD) ; n++ ;
	XtSetArg(args[n], XmNorientation, XmVERTICAL) ; n++ ;
	Widget frame_work = XmCreateRowColumn(name_display, "frame_work", args, n) ;
	n = 0 ;
	_filename_label = XmCreateLabel(frame_work, "name_label", args, n) ;
	XtManageChild(_filename_label) ;
	n = 0 ;
	_filesize_label = XmCreateLabel(frame_work, "size_label", args, n) ;
	XtManageChild(_filesize_label) ;
	n = 0 ;
	_modtime_label = XmCreateLabel(frame_work, "modtime_label", args, n) ;
	XtManageChild(_modtime_label) ;
	XtManageChild(frame_work) ;

	XtManageChild(name_display) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, name_display) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget sep1 = XmCreateSeparator(_form->widget(), "sep1", args, n) ;
	XtManageChild(sep1) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, sep1) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget group_display = XmCreateFrame(_form->widget(), "group_frame",
		args, n) ;
	n = 0 ;
	XtSetArg(args[n], XmNframeChildType, XmFRAME_TITLE_CHILD) ; n++ ;
	Widget group_title = XmCreateLabel(group_display, "doc_info", args, n) ;
	XtManageChild(group_title) ;
	n = 0 ;
	XtSetArg(args[n], XmNframeChildType, XmFRAME_WORKAREA_CHILD) ; n++ ;
	XtSetArg(args[n], XmNorientation, XmVERTICAL) ; n++ ;
	Widget group_work = XmCreateRowColumn(group_display, "group_work",
		args, n) ;

	n = 0 ;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
	Widget author_work = XmCreateRowColumn(group_work, "author_work", args, n) ;
	n = 0 ;
	Widget author_title = XmCreateLabel(author_work, "author_label", args, n) ;
	XtManageChild(author_title) ;
	n = 0 ;
	_author_entry = XmCreateTextField(author_work, "author_entry", args, n) ;
	XtAddCallback(_author_entry, XmNactivateCallback, author_entry_cb,
		(XtPointer)this) ;
	XtManageChild(_author_entry) ;
	XtManageChild(author_work) ;

	n = 0 ;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
	Widget revision_work = XmCreateRowColumn(group_work, "revision_work",
		args, n) ;
	n = 0 ;
	Widget revision_title = XmCreateLabel(revision_work, "revision_label",
		args, n) ;
	XtManageChild(revision_title) ;
	n = 0 ;
	_revision_entry = XmCreateTextField(revision_work, "revision_entry",
		args, n) ;
	XtAddCallback(_revision_entry, XmNactivateCallback, revision_entry_cb,
		(XtPointer)this) ;
	XtManageChild(_revision_entry) ;
	n = 0 ;
	_count_label = XmCreateLabel(group_work, "count_label", args, n) ;
	XtManageChild(_count_label) ;
	XtManageChild(revision_work) ;

	XtManageChild(group_work) ;

	XtManageChild(group_display) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, group_display) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget sep2 = XmCreateSeparator(_form->widget(), "sep2", args, n) ;
	XtManageChild(sep2) ;

	Application *appl = Application::instance() ;

	_prolog_button = new MenuButton("edit_prolog", _form) ;
	n = 0 ; 
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, sep2) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	_prolog_button->setValues(args, n) ;
	_prolog_button->command(new MGDD_Command(this,
		MachineGroupDialogDirector::edit_prolog)) ;
	_prolog_button->manage() ;
	_prolog_editor = new TextEditor("Group Prolog", appl) ;
	_prolog_editor->save_command(new MGDD_Command(this,
		MachineGroupDialogDirector::set_prolog)) ;

	_epilog_button = new MenuButton("edit_epilog", _form) ;
	n = 0 ; 
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, _prolog_button->widget()) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomOffset, 10) ; n++ ;
	_epilog_button->setValues(args, n) ;
	_epilog_button->command(new MGDD_Command(this,
		MachineGroupDialogDirector::edit_epilog)) ;
	_epilog_button->manage() ;
	_epilog_editor = new TextEditor("Group Epilog", appl) ;
	_epilog_editor->save_command(new MGDD_Command(this,
		MachineGroupDialogDirector::set_epilog)) ;

	_document.attach(this) ;
}

MachineGroupDialogDirector::
~MachineGroupDialogDirector()
{
	delete _prolog_editor ;
	delete _prolog_button ;
	delete _epilog_editor ;
	delete _epilog_button ;
	delete _form ;
	_document.detach(this) ;
}

void MachineGroupDialogDirector::
show_dialog()
{
	update(&_document) ;
	_form->manage() ;
}

void MachineGroupDialogDirector::
dismiss_dialog()
{
	_form->unmanage() ;
}

void MachineGroupDialogDirector::
update(
	const Subject *subject)
{
	assert(subject == &_document) ;
	MachineGroup *old_group = _group ;
	_group = _document.machine_group() ;
	if (_group == NULL || old_group == _group)
		return ;

	_prolog_editor->set_text(_group->group_prolog().c_str()) ;
	_epilog_editor->set_text(_group->group_epilog().c_str()) ;

	const FileName& fn = _document.filename() ;
	XmCxxString file_name(fn.c_str()) ;
	XtVaSetValues(_filename_label, XmNlabelString, (XmString)file_name,
		NULL) ;

	ostrstream fsize_str ;
	fsize_str << fn.file_size() << " bytes" << ends ;
	XmCxxString file_size(fsize_str.str()) ;
	XtVaSetValues(_filesize_label, XmNlabelString, (XmString)file_size,
		NULL) ;

	ostrstream mtime_str ;
	time_t mt = fn.modify_time() ;
	mtime_str << "Last Modified: " ;
	if (mt != 0)
		mtime_str << ctime(&mt) ;
	mtime_str << ends ;
	XmCxxString mod_time(mtime_str.str()) ;
	XtVaSetValues(_modtime_label, XmNlabelString, (XmString)mod_time,
		NULL) ;

	XmTextFieldSetString(_author_entry, 
		(char *)_group->author().internal_to_external().c_str()) ;
	XmTextFieldSetString(_revision_entry, 
		(char *)_group->revision().internal_to_external().c_str()) ;
	ostrstream cnt_str ;
	cnt_str << "State Machines in Group: "
		<< _group->machine_list().size() << ends ;
	XmCxxString count(cnt_str.str()) ;
	XtVaSetValues(_count_label, XmNlabelString, (XmString)count,
		NULL) ;
}

void MachineGroupDialogDirector::
subject_deleted(
	Subject *subject)
{
	assert(subject == &_document) ;
	// "this" is deleted in the destructor for GsmDocument.
}

bool MachineGroupDialogDirector::
modified() const
{
	bool mod = false ;

	if (mod == false)
		mod = _prolog_editor->modified() ;
	if (mod == false)
		mod = _epilog_editor->modified() ;

	return mod ;
}

void MachineGroupDialogDirector::
modified(
	bool new_modified)
{
	_prolog_editor->modified(new_modified) ;
	_epilog_editor->modified(new_modified) ;
}

void MachineGroupDialogDirector::
set_author()
{
	char *author_entered = XmTextFieldGetString(_author_entry) ;
	_group->author(ChioTerm(author_entered, ChioTerm::StringChioTerm,
		ChioTerm::ExternalChioTerm)) ;
	XtFree(author_entered) ;
}

void MachineGroupDialogDirector::
set_revision()
{
	char *revision_entered = XmTextFieldGetString(_revision_entry) ;
	_group->revision(ChioTerm(revision_entered, ChioTerm::StringChioTerm,
		ChioTerm::ExternalChioTerm)) ;
	XtFree(revision_entered) ;
}

void MachineGroupDialogDirector::
set_prolog()
{
	_group->group_prolog(ChioTerm(_prolog_editor->get_text(),
		ChioTerm::MultiLineChioTerm)) ;
}

void MachineGroupDialogDirector::
set_epilog()
{
	_group->group_epilog(ChioTerm(_epilog_editor->get_text(),
		ChioTerm::MultiLineChioTerm)) ;
}

void MachineGroupDialogDirector::
edit_prolog()
{
	_prolog_editor->manage() ;
}

void MachineGroupDialogDirector::
edit_epilog()
{
	_epilog_editor->manage() ;
}

void MachineGroupDialogDirector::
author_entry_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	MachineGroupDialogDirector *dd = (MachineGroupDialogDirector *)closure ;
	dd->set_author() ;
	XmProcessTraversal(widget, XmTRAVERSE_NEXT_TAB_GROUP) ;
}

void MachineGroupDialogDirector::
revision_entry_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	MachineGroupDialogDirector *dd = (MachineGroupDialogDirector *)closure ;
	dd->set_revision() ;
	XmProcessTraversal(widget, XmTRAVERSE_PREV_TAB_GROUP) ;
}
