/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: InputCommand.cc,v $
$Revision: 1.7 $
$Date: 1997/07/02 04:45:07 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: InputCommand.cc,v $
Revision 1.7  1997/07/02 04:45:07  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.6  1997/06/21 02:21:32  andrewm
Checkpoint.  PostScript generator going well. A lot of small tweeks
all over to accomplish this.

Revision 1.5  1997/06/06 04:34:25  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.4  1997/03/12 03:13:06  andrewm
Checkpoint.  Things are working rather well.

Revision 1.3  1996/09/22 01:47:02  andrewm
pre-alpha release

// Revision 1.2  1996/08/05  01:27:42  andrewm
// checkpoint
//
// Revision 1.2  1996/08/05  01:27:42  andrewm
// checkpoint
//
// Revision 1.1  1996/07/27  20:58:52  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <assert.h>

#include "Document.h"
#include "GraphicRenderer.h"
#include "InputCommand.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: InputCommand.cc,v $ $Revision: 1.7 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

void InputCommand::
execute(
	XmAnyCallbackStruct *callback_data)
{
	XmDrawingAreaCallbackStruct *cbs =
		(XmDrawingAreaCallbackStruct *)callback_data ;
	XEvent *event = cbs->event ;
	assert(event != NULL) ;
	XButtonEvent *bev = &event->xbutton ;
	XMotionEvent *mev = &event->xmotion ;
	GraphicRenderer& render = GraphicRenderer::instance() ;

	Point location ;

	switch (event->type)
	{
	case ButtonPress:
		location = render.scale_to_mm(Point(bev->x, bev->y)) ;
		_start_location = location ;
		switch (bev->button)
		{
		case Button1:
			_document->button_1_press(location) ;
			break ;

		case Button2:
			_document->button_2_press(location) ;
			break ;

		case Button3:
			_document->button_3_press(location) ;
			break ;
		}
		break ;

	case ButtonRelease:
		location = render.scale_to_mm(Point(bev->x, bev->y)) ;
		switch (bev->button)
		{
		case Button1:
			_document->button_1_release(location) ;
			break ;

		case Button2:
			_document->button_2_release(location) ;
			break ;

		case Button3:
			_document->button_3_release(location) ;
			break ;
		}
		break ;

	case MotionNotify:
		location = render.scale_to_mm(Point(mev->x, mev->y)) ;
		if (mev->state & ControlMask)
		{
			if (abs(location.x() - _start_location.x()) >
				abs(location.y() - _start_location.y()))
			{
				location.y() = _start_location.y() ;
			}
			else
			{
				location.x() = _start_location.x() ;
			}
		}

		if (mev->state & Button1Mask)
			_document->button_1_motion(location) ;
		else if (mev->state & Button2Mask)
			_document->button_2_motion(location) ;
		else if (mev->state & Button3Mask)
			_document->button_3_motion(location) ;
		break ;
	}
}
