/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: GsmMenuBar.cc,v $
$Revision: 1.7 $
$Date: 1997/07/02 04:45:07 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: GsmMenuBar.cc,v $
Revision 1.7  1997/07/02 04:45:07  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.6  1997/07/01 03:54:33  andrewm
Changes in the way code is generated.  Now there is an initial event
function that must be called after construction but before any
other events are triggered.  This is to help integration of generated
classes into a class hierarchy.

Revision 1.5  1997/04/27 00:56:54  andrewm
On more checkpoint before release.

Revision 1.4  1997/04/08 04:34:29  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

Revision 1.3  1997/03/30 02:07:28  andrewm
Checkpoint.  Things working well. About to change the way
machines are stored in the backing file.

Revision 1.2  1997/03/18 06:51:02  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.1  1997/03/04 06:32:53  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "GsmMenuBar.h"
#include "MenuPulldown.h"
#include "MenuButton.h"
#include "MenuSeparator.h"
#include "InfoDialog.h"
#include "Application.h"
#include "Document.h"
#include "Command.h"
#include "FileOpenDialogDirector.h"
#include "FileNewDialogDirector.h"
#include "FileSaveAsDialogDirector.h"
#include "SaveDialogDirector.h"
#include "ExitDialogDirector.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: GsmMenuBar.cc,v $ $Revision: 1.7 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

GsmMenuBar::
GsmMenuBar(
	const char *name,
	MainWindow *parent) :
		MenuBar(name, parent),
		_open_director(NULL),
		_new_director(NULL),
		_save_as_director(NULL),
		_exit_director(NULL)
{
}

GsmMenuBar::
~GsmMenuBar()
{
	delete _open_director ;
	delete _new_director ;
	delete _save_as_director ;
	delete _exit_director ;
}

MenuPulldown *GsmMenuBar::
template_create_file_menu(
	const char *name,
	MenuBar *parent)
{
	Document *document = Application::instance()->document() ;
		// The "File" pulldown
	MenuPulldown *pull = new MenuPulldown(name, parent) ;

		// Create the button that will be used to invoke the "Open" actions.
	MenuButton *button = new MenuButton("open", pull) ;
	pull->add(button) ;
	_open_director = new FileOpenDialogDirector(parent, *document) ;
	button->command(new SimpleCommand<DialogDirector>(
		_open_director, DialogDirector::show_dialog)) ;

	button = new MenuButton("new", pull) ;
	pull->add(button) ;
	_new_director = new FileNewDialogDirector(parent, *document) ;
	button->command(new SimpleCommand<DialogDirector>(
		_new_director, DialogDirector::show_dialog)) ;

		// The command sequence for the "Save" menu item.
		// Save is very simple and just executes the Document "save"
		// function.
	button = new MenuButton("save", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document, Document::save)) ;

	button = new MenuButton("save_as", pull) ;
	pull->add(button) ;
	_save_as_director = new FileSaveAsDialogDirector(parent, *document) ;
	button->command(new SimpleCommand<DialogDirector>(
		_save_as_director, DialogDirector::show_dialog)) ;

		// The separator is for aestetics.
	pull->add(new MenuSeparator("sep", pull)) ;

	button = new MenuButton("exit", pull) ;
	pull->add(button) ;
	_exit_director = new ExitDialogDirector(parent, *document) ;
	button->command(new SimpleCommand<DialogDirector>(
		_exit_director, DialogDirector::show_dialog)) ;
	Application::instance()->deleteWindow_command(
		new SimpleCommand<DialogDirector>(
		_exit_director, DialogDirector::show_dialog)) ;

	return pull ;
}

MenuPulldown *GsmMenuBar::
template_create_edit_menu(
	const char *name,
	MenuBar *parent)
{
	Document *document = Application::instance()->document() ;
		// The "Edit" pulldown
	MenuPulldown *pull = new MenuPulldown(name, parent) ;

	MenuButton *button = new MenuButton("change_mode", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::set_change_mode)) ;

	button = new MenuButton("insert_mode", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::set_insert_mode)) ;

	button = new MenuButton("delete_mode", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::set_delete_mode)) ;

	pull->add(new MenuSeparator("sep1", pull)) ;

	button = new MenuButton("edit_group", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::edit_document_params)) ;

	button = new MenuButton("edit_machine", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::edit_page_params)) ;

	button = new MenuButton("edit_events", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::edit_page_events)) ;

	button = new MenuButton("edit_state", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::edit_component_params)) ;

	pull->add(new MenuSeparator("sep2", pull)) ;

	button = new MenuButton("select_all", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::select_all)) ;

	button = new MenuButton("deselect_all", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::deselect_all)) ;

	return pull ;
}

MenuPulldown *GsmMenuBar::
template_create_view_menu(
	const char *name,
	MenuBar *parent)
{
	Document *document = Application::instance()->document() ;
		// The "View" pulldown
	MenuPulldown *pull = new MenuPulldown(name, parent) ;

	MenuButton *button = new MenuButton("first", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::first_page)) ;

	button = new MenuButton("last", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::last_page)) ;

	button = new MenuButton("next", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::next_page)) ;

	button = new MenuButton("previous", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::previous_page)) ;

	pull->add(new MenuSeparator("sep", pull)) ;

	button = new MenuButton("delete", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::delete_page)) ;

	pull->add(new MenuSeparator("sep", pull)) ;

	button = new MenuButton("refresh", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::refresh)) ;

	return pull ;
}

MenuPulldown *GsmMenuBar::
template_create_special_menu(
	const char *name,
	MenuBar *parent)
{
	Document *document = Application::instance()->document() ;
		// The "Special" pulldown
	MenuPulldown *pull = new MenuPulldown(name, parent) ;

	MenuButton *button = new MenuButton("check_states", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::check_states)) ;

	button = new MenuButton("check_trans", pull) ;
	pull->add(button) ;
	button->command(new SimpleCommand<Document>(document,
		Document::check_transitions)) ;

	return pull ;
}

MenuPulldown *GsmMenuBar::
template_create_options_menu(
	const char *name,
	MenuBar *parent)
{
#if 0 /* no options right now */
		// The "Options" pulldown
	MenuPulldown *pull = new MenuPulldown(name, parent) ;

	return pull ;
#else
	return NULL ;
#endif
}

MenuPulldown *GsmMenuBar::
template_create_help_menu(
	const char *name,
	MenuBar *parent)
{
		// The "Help" pulldown
	MenuPulldown *pull = new MenuPulldown(name, parent) ;

	MenuButton *button = new MenuButton("on_version", pull) ;
	pull->add(button) ;
	InfoDialog *id = new InfoDialog("version", pull) ;
	id->ok_command(new NullCommand) ;
	button->command(new SimpleCommand<UIComponent>(id, &UIComponent::manage)) ;

	button = new MenuButton("on_copyright", pull) ;
	pull->add(button) ;
	id = new InfoDialog("copyright", pull) ;
	id->ok_command(new NullCommand) ;
	button->command(new SimpleCommand<UIComponent>(id, &UIComponent::manage)) ;

	button = new MenuButton("on_license", pull) ;
	pull->add(button) ;
	id = new InfoDialog("license", pull) ;
	id->ok_command(new NullCommand) ;
	button->command(new SimpleCommand<UIComponent>(id, &UIComponent::manage)) ;

	return pull ;
}
