/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: GsmMainWindow.cc,v $
$Revision: 1.12 $
$Date: 1997/07/02 04:45:06 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: GsmMainWindow.cc,v $
Revision 1.12  1997/07/02 04:45:06  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.11  1997/03/18 06:51:02  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.10  1997/03/12 03:13:05  andrewm
Checkpoint.  Things are working rather well.

Revision 1.9  1997/03/04 06:32:53  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.8  1996/11/27 01:25:52  andrewm
Another checkpoint before I go off and figure out what to do about
the graphical representations so that I'll be able to get some post script
output one of these days.

Revision 1.7  1996/11/14 06:21:12  andrewm
checkpoint

// Revision 1.6  1996/10/01  04:40:57  andrewm
// checkpoint and revision
//
// Revision 1.5  1996/09/22  01:20:41  andrewm
// pre-alpha release
//
// Revision 1.4  1996/08/18  18:00:01  andrewm
// checkpoint
//
// Revision 1.3  1996/08/05  01:27:42  andrewm
// checkpoint
//
// Revision 1.2  1996/07/27  20:58:52  andrewm
// checkpoint
//
// Revision 1.1  1996/07/15  01:22:32  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "GsmMainWindow.h"
#include "GsmMenuBar.h"
#include "GsmDrawingArea.h"
#include "GsmMessageArea.h"
#include "Toolbar.h"
#include "MenuButton.h"
#include "Application.h"
#include "Document.h"
#include "Command.h"

#include <Xm/Separator.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: GsmMainWindow.cc,v $ $Revision: 1.12 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

GsmMainWindow::
GsmMainWindow(
	const char *name,
	Application *parent) :
		MainWindow(name, parent),
		_sep1(NULL),
		_sep2(NULL),
		_sep3(NULL)
{
}

MenuBar *GsmMainWindow::
template_create_menu_bar(
	const char *name,
	MainWindow *parent)
{
	GsmMenuBar *menu_bar = new GsmMenuBar(name, parent) ;

	Arg args[10] ;
	Cardinal n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE) ; n++ ;
	menu_bar->setValues(args, n) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, menu_bar->widget()) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE) ; n++ ;
	_sep1 = XmCreateSeparator(_widget, "sep1", args, n) ;
	XtManageChild(_sep1) ;

	Toolbar *toolbar = new Toolbar("toolbar", parent) ;
	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, _sep1) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE) ; n++ ;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
	toolbar->setValues(args, n) ;

	Document *document = Application::instance()->document() ;
	MenuButton *toolbutton = new MenuButton("change", toolbar) ;
	toolbar->add(toolbutton) ;
	toolbutton->command(new SimpleCommand<Document>(document,
		Document::set_change_mode)) ;

	toolbutton = new MenuButton("insert", toolbar) ;
	toolbar->add(toolbutton) ;
	toolbutton->command(new SimpleCommand<Document>(document,
		Document::set_insert_mode)) ;

	toolbutton = new MenuButton("delete", toolbar) ;
	toolbar->add(toolbutton) ;
	toolbutton->command(new SimpleCommand<Document>(document,
		Document::set_delete_mode)) ;

	toolbar->manage() ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, toolbar->widget()) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE) ; n++ ;
	_sep2 = XmCreateSeparator(_widget, "sep2", args, n) ;
	XtManageChild(_sep2) ;

	return menu_bar ;
}

DrawingArea *GsmMainWindow::
template_create_drawing_area(
	const char *name,
	MainWindow *parent)
{
	GsmDrawingArea *drawing_area = new GsmDrawingArea(name, parent) ;
	drawing_area->manage() ;

	Arg args[10] ;
	Cardinal n = 0 ;

	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	_sep3 = XmCreateSeparator(_widget, "sep3", args, n) ;
	XtManageChild(_sep3) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, _sep2) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNbottomWidget, _sep3) ; n++ ;
	drawing_area->setValues(args, n) ;

	return drawing_area ;
}

MessageArea *GsmMainWindow::
template_create_message_area(
	const char *name,
	MainWindow *parent)
{
	MessageArea *message_area = new GsmMessageArea(name, parent) ;
	message_area->manage() ;

	Widget message_parent = XtParent(message_area->widget()) ;
	Arg args[10] ;
	Cardinal n = 0 ;

	XtSetArg(args[n], XmNtopAttachment, XmATTACH_NONE) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNbottomWidget, message_parent) ; n++ ;
	XtSetValues(_sep3, args, n) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_NONE) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	XtSetValues(message_parent, args, n) ;

	return message_area ;
}
