/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: GsmDocument.h,v $
$Revision: 1.8 $
$Date: 1997/07/02 04:45:06 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: GsmDocument.h,v $
Revision 1.8  1997/07/02 04:45:06  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.7  1997/06/06 04:34:24  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.6  1997/04/16 04:06:14  andrewm
Checkpoint, as last major dialog is in.

Revision 1.5  1997/04/08 04:34:29  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

Revision 1.4  1997/03/30 02:07:28  andrewm
Checkpoint.  Things working well. About to change the way
machines are stored in the backing file.

Revision 1.3  1997/03/18 06:51:02  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.2  1997/03/12 03:13:05  andrewm
Checkpoint.  Things are working rather well.

Revision 1.1  1997/03/04 06:32:52  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

 *--
 */
#ifndef _GsmDocument_h_
#define _GsmDocument_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Document.h"
#include "MachineGroup.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS FORWARD REFERENCES
*/
class PageGroup ;
class DocPageState ;
class MachineGroupDialogDirector ;
class SmachineDialogDirector ;
class MachEventDialogDirector ;
class StateDialogDirector ;
class Smachine ;
class State ;

/*
CLASS DEFINITIONS
*/
class GsmDocument :
	public Document
{
public:
	GsmDocument() ;
	virtual ~GsmDocument() ;

	virtual void open(const char *filename, bool draw) ;
	virtual void new_doc() ;
	virtual void close() ;
	virtual void save() ;
	virtual void save(const char *filename) ;
	virtual bool modified() ;
	virtual void redraw() ;
	virtual void refresh() ;

	virtual void button_1_press(const Point& p) ;
	virtual void button_1_release(const Point& p) ;
	virtual void button_1_motion(const Point& p) ;
	virtual void button_2_press(const Point& p) ;
	virtual void button_2_release(const Point& p) ;
	virtual void button_2_motion(const Point& p) ;
	virtual void button_3_press(const Point& p) ;
	virtual void button_3_release(const Point& p) ;
	virtual void button_3_motion(const Point& p) ;

	virtual void select_all() ;
	virtual void deselect_all() ;
	virtual void set_change_mode() ;
	virtual void set_insert_mode() ;
	virtual void set_delete_mode() ;

	virtual void first_page() ;
	virtual void last_page() ;
	virtual void next_page() ;
	virtual void previous_page() ;
	virtual void delete_page() ;

	virtual void edit_document_params() ;
	virtual void edit_page_params() ;
	virtual void edit_page_events() ;
	virtual void edit_component_params() ;

	virtual void check_states() ;
	virtual void check_transitions() ;

	MachineGroup *machine_group() const { return _machine_group ; }
	Smachine *current_machine() const ;
	DocPageState *page_state() const { return _doc_page_state ; }

private:
	void set_modified(bool new_modified) ;
	void set_page_mode() ;

private:
	MachineGroup *_machine_group ;
	MachineGroup::SmachineList *_machine_list ;
	MachineGroup::SmachineListIter _machine_iter ;
	PageGroup *_page_group ;
	DocPageState *_doc_page_state ;
	MachineGroupDialogDirector *_mg_dialog ;
	SmachineDialogDirector *_sm_dialog ;
	MachEventDialogDirector *_me_dialog ;
	StateDialogDirector *_st_dialog ;
} ;


#endif /* _GsmDocument_h_ */
