/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: GsmApplication.cc,v $
$Revision: 1.8 $
$Date: 1997/07/02 04:45:05 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: GsmApplication.cc,v $
Revision 1.8  1997/07/02 04:45:05  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.7  1997/06/15 00:43:55  andrewm
Another checkpoint.  Reworked the way text is specfied to be drawn
for the benefit of the post script renderer.

Revision 1.6  1997/03/04 06:32:52  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.5  1996/11/17 21:50:51  andrewm
Converting to the new version of g++ (2.7.2) and now everything
is under CVS.

Revision 1.4  1996/09/22 01:47:02  andrewm
pre-alpha release

// Revision 1.3  1996/08/05  01:27:42  andrewm
// checkpoint
//
// Revision 1.3  1996/08/05  01:27:42  andrewm
// checkpoint
//
// Revision 1.2  1996/07/27  20:58:52  andrewm
// checkpoint
//
// Revision 1.1  1996/07/15  01:22:32  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "GsmApplication.h"
#include "GsmMainWindow.h"
#include "GsmDocument.h"
#include "DrawingArea.h"
#include "XGraphicRenderer.h"

#include <Xm/Xm.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: GsmApplication.cc,v $ $Revision: 1.8 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

void GsmApplication::
template_get_appl_resources()
{
}

void GsmApplication::
template_realize()
{
	XGraphicRenderer *xr = new XGraphicRenderer ;
	GraphicRenderer::instance(xr) ;

	XmRenderTable rtable ;
	XtVaGetValues(_widget, XmNtextRenderTable, &rtable, NULL) ;
	xr->set_context(_main_window->drawing_area()->draw_widget(), rtable) ;
	xr->realize_context() ;
}

MainWindow *GsmApplication::
template_create_main_window(
	const char *name,
	Application *parent)
{
	GsmMainWindow *mw = new GsmMainWindow(name, parent) ;
	mw->initialize() ;
	return mw ;
}

Document *GsmApplication::
template_create_document()
{
	return new GsmDocument() ;
}
