/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: ExitDialogDirector.cc,v $
$Revision: 1.3 $
$Date: 1997/07/02 04:45:02 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: ExitDialogDirector.cc,v $
Revision 1.3  1997/07/02 04:45:02  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.2  1997/03/30 02:07:27  andrewm
Checkpoint.  Things working well. About to change the way
machines are stored in the backing file.

Revision 1.1  1997/03/04 06:34:39  andrewm
New director objects used for more complex dialogs.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "ExitDialogDirector.h"
#include "UIComponent.h"
#include "Application.h"
#include "QuestionDialog.h"
#include "Document.h"
#include "Command.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/
typedef SimpleCommand<ExitDialogDirector> EDD_Command ;

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: ExitDialogDirector.cc,v $ $Revision: 1.3 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

ExitDialogDirector::
ExitDialogDirector(
	UIComponent *parent,
	Document& document) :
		SaveDialogDirector(parent, document),
		_exit_question(new QuestionDialog("exitDialog", parent))
{
	_exit_question->ok_command(
		new EDD_Command(this, ExitDialogDirector::exit_yes)) ;
	_exit_question->cancel_command(
		new EDD_Command(this, ExitDialogDirector::exit_no)) ;
}

ExitDialogDirector::
~ExitDialogDirector()
{
	delete _exit_question ;
}

void ExitDialogDirector::
show_dialog()
{
	if (_document.modified())
		_question->manage() ;
	else
		_exit_question->manage() ;
}

void ExitDialogDirector::
save_yes()
{
	_document.save() ;
	_exit_question->manage() ;
}

void ExitDialogDirector::
save_no()
{
	_exit_question->manage() ;
}

void ExitDialogDirector::
exit_yes()
{
	Application::instance()->exit_appl() ;
}

void ExitDialogDirector::
exit_no()
{
}
