/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: DocPageState.h,v $
$Revision: 1.6 $
$Date: 1997/07/02 04:45:02 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: DocPageState.h,v $
Revision 1.6  1997/07/02 04:45:02  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.5  1997/06/06 04:34:24  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.4  1997/04/16 04:06:13  andrewm
Checkpoint, as last major dialog is in.

Revision 1.3  1997/03/30 02:07:27  andrewm
Checkpoint.  Things working well. About to change the way
machines are stored in the backing file.

Revision 1.2  1997/03/18 06:51:01  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.1  1997/03/12 03:13:05  andrewm
Checkpoint.  Things are working rather well.

 *--
 */
#ifndef _DocPageState_h_
#define _DocPageState_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Geom2d.h"
#include "Observer.h"

#include <X11/Xlib.h>
#include <Xm/Xm.h>

/*
MACRO DEFINITIONS
*/

/*
CLASS FORWARD REFERENCES
*/

/*
CLASS DEFINITIONS
*/

class GsmDocument ;
class Smachine ;
class State ;
class Transition ;

class DocPageState :
	public Observer,
	public Subject
{
public:
	DocPageState(GsmDocument& doc) ;
	virtual ~DocPageState() ;

	virtual void update(const Subject *subject) ;
	virtual void subject_deleted(Subject *subject) ;

	virtual void button_1_press(const Point& p) = 0 ;
	virtual void button_1_release(const Point& p) = 0 ;
	virtual void button_1_motion(const Point& p) = 0 ;
	virtual void button_2_press(const Point& p) = 0 ;
	virtual void button_2_release(const Point& p) = 0 ;
	virtual void button_2_motion(const Point& p) = 0 ;
	virtual void button_3_press(const Point& p) = 0 ;
	virtual void button_3_release(const Point& p) = 0 ;
	virtual void button_3_motion(const Point& p) = 0 ;

	State *current_state() const { return _current_state ; }

protected:
	void define_cursor(Cursor cursor) ;

protected:
	GsmDocument& _doc ;
	Smachine *_current_machine ;
	State *_state_at_cursor ;
	Transition *_trans_at_cursor ;
	State *_current_state ;
} ;

class RubberBand ;

class DocPageChangeState :
	public DocPageState
{
public:
	DocPageChangeState(GsmDocument& doc) ;
	~DocPageChangeState() ;

	virtual void button_1_press(const Point& p) ;
	virtual void button_1_release(const Point& p) ;
	virtual void button_1_motion(const Point& p) ;
	virtual void button_2_press(const Point& p) ;
	virtual void button_2_release(const Point& p) ;
	virtual void button_2_motion(const Point& p) ;
	virtual void button_3_press(const Point& p) ;
	virtual void button_3_release(const Point& p) ;
	virtual void button_3_motion(const Point& p) ;

private:
	Point _ref_point ;
	RubberBand *_rubber_band ;
} ;

class RubberLine ;
class EventSelectionDialog ;

class DocPageInsertState :
	public DocPageState
{
public:
	DocPageInsertState(GsmDocument& doc) ;
	~DocPageInsertState() ;

	virtual void button_1_press(const Point& p) ;
	virtual void button_1_release(const Point& p) ;
	virtual void button_1_motion(const Point& p) ;
	virtual void button_2_press(const Point& p) ;
	virtual void button_2_release(const Point& p) ;
	virtual void button_2_motion(const Point& p) ;
	virtual void button_3_press(const Point& p) ;
	virtual void button_3_release(const Point& p) ;
	virtual void button_3_motion(const Point& p) ;

public:
	void event_ok(XmAnyCallbackStruct *callback) ;
	void event_cancel(XmAnyCallbackStruct *callback) ;

private:
	Cursor _insert_cursor ;
	State *_begin_state ;
	State *_end_state ;
	RubberLine *_rl ;
	EventSelectionDialog *_select ;
} ;

class DocPageDeleteState :
	public DocPageState
{
public:
	DocPageDeleteState(GsmDocument& doc) ;
	~DocPageDeleteState() ;

	virtual void button_1_press(const Point& p) ;
	virtual void button_1_release(const Point& p) ;
	virtual void button_1_motion(const Point& p) ;
	virtual void button_2_press(const Point& p) ;
	virtual void button_2_release(const Point& p) ;
	virtual void button_2_motion(const Point& p) ;
	virtual void button_3_press(const Point& p) ;
	virtual void button_3_release(const Point& p) ;
	virtual void button_3_motion(const Point& p) ;

private:
	Cursor _delete_cursor ;
} ;


#endif /* _DocPageState_h_ */
