/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:
	gsmcheck -- check for improperly constructed state machines.

$RCSfile: gsmcheck.cc,v $
$Revision: 1.5 $
$Date: 1997/07/14 02:30:33 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: gsmcheck.cc,v $
Revision 1.5  1997/07/14 02:30:33  andrewm
Checkpoint.  Rework makefiles.  Rework man pages.  Fixed PostScript problems.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <fstream.h>
#include <string.h>

#include "Chio.h"
#include "MachineGroup.h"
#include "TransitionCheckVisitor.h"
#include "StateCheckVisitor.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: gsmcheck.cc,v $ $Revision: 1.5 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

main(
	int argc,
	char **argv)
{
	char *progname = *argv ;
	char *parg ;

	int return_code = 0 ;
	while (parg = *++argv)
	{
		string filename(parg) ;

		ifstream in_file(filename.c_str()) ;
		if (!in_file)
		{
			cerr << progname << ": Cannot open file \"" << filename
				<< "\" for reading: " << strerror(errno) << endl ;
			return_code = 2 ;
			continue ;
		}

		ChioMap file_map ;
		in_file >> file_map ;
		MachineGroup machine_group(file_map) ;

		TransitionCheckVisitor trans_check ;
		machine_group.accept_visitor(trans_check) ;
		if (trans_check.discrepancies() != 0)
		{
			cerr << progname << ": " << filename <<
				": Transition Error: Event/State parameter mismatch" << endl ;
			cerr << trans_check ;
			return_code = 1 ;
			continue ;
		}

		StateCheckVisitor state_check ;
		machine_group.accept_visitor(state_check) ;
		if (state_check.discrepancies() != 0)
		{
			cerr << progname << ": " << filename <<
				": State configuration error" << endl ;
			cerr << state_check ;
			return_code = 1 ;
			continue ;
		}
	}
	return return_code ;
}
