/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: UIComponent.cc,v $
$Revision: 1.6 $
$Date: 1997/07/02 04:44:57 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: UIComponent.cc,v $
Revision 1.6  1997/07/02 04:44:57  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.5  1997/03/04 06:32:49  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.4  1997/02/23 23:44:09  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.3  1996/09/22 01:46:34  andrewm
pre-alpha release

// Revision 1.2  1996/07/15  01:22:04  andrewm
// checkpoint again
//
// Revision 1.2  1996/07/15  01:22:04  andrewm
// checkpoint again
//
// Revision 1.1  1996/07/13  19:32:43  andrewm
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
// UIComponent.C: Base class for all C++/Motif UI components
/////////////////////////////////////////////////////////////////
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <assert.h>
#include <strstream.h>

#include "UIComponent.h"
#include <Xm/Xm.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: UIComponent.cc,v $ $Revision: 1.6 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

UIComponent::
~UIComponent()
{
	if (_widget)
	{
			// Remove destroy callback so Xt can't call the callback
			// with a pointer to an object that has already been freed
		XtRemoveCallback(_widget, XmNdestroyCallback,
			&UIComponent::widgetDestroyedCallback, (XtPointer)this) ;
		XtDestroyWidget(_widget) ;
	}
}

void UIComponent::
manage() const
{
	assert(_widget != NULL) ;
	assert(XtHasCallbacks(_widget, XmNdestroyCallback) == XtCallbackHasSome) ;
	XtManageChild(_widget) ;
}

void UIComponent::
unmanage() const
{
	assert(_widget != NULL) ;
	assert(XtHasCallbacks(_widget, XmNdestroyCallback) == XtCallbackHasSome) ;
	XtUnmanageChild(_widget) ;
}

void UIComponent::
setValue(
	const string& name,
	XtArgVal value)
{
	assert(_widget != NULL) ;
	XtVaSetValues(_widget, name.c_str(), value, NULL) ;
}

void UIComponent::
setValues(
	ArgList args,
	Cardinal num_args)
{
	assert(_widget != NULL) ;
	XtSetValues(_widget, args, num_args) ;
}

void UIComponent::
getValue(
	const string& name,
	XtArgVal *value)
{
	assert(_widget != NULL) ;
	XtVaGetValues(_widget, name.c_str(), value, NULL) ;
}

void UIComponent::
getValues(
	ArgList args,
	Cardinal num_args)
{
	assert(_widget != NULL) ;
	XtGetValues(_widget, args, num_args) ;
}

UIComponent::
UIComponent() :
		_widget(NULL)
{
}

void UIComponent::
installDestroyHandler()
{
	assert(_widget != NULL) ;
	XtAddCallback(_widget, XmNdestroyCallback,
		&UIComponent::widgetDestroyedCallback, (XtPointer)this) ;
}

void UIComponent::
widgetDestroyed()
{
	_widget = NULL ;
}

void UIComponent::
widgetDestroyedCallback(
	Widget widget,
	XtPointer client_data,
	XtPointer call_data)
{
	UIComponent *obj = (UIComponent *)client_data ;
	obj->widgetDestroyed() ;
}
