/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: TwoPartSelectionBox.cc,v $
$Revision: 1.3 $
$Date: 1997/07/02 04:44:57 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: TwoPartSelectionBox.cc,v $
Revision 1.3  1997/07/02 04:44:57  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.2  1997/04/12 21:14:56  andrewm
Checkpoint after adding the event dialog.

Revision 1.1  1997/04/08 04:34:25  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "TwoPartSelectionBox.h"

#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/Separator.h>
#include <XmCxx/CxxXmString.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: TwoPartSelectionBox.cc,v $ $Revision: 1.3 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

TwoPartSelectionBox::
TwoPartSelectionBox(
	const char *name,
	UIComponent *parent) :
		_ok_command(NULL),
		_apply_command(NULL),
		_cancel_command(NULL),
		_help_command(NULL)
{
	Arg args[10] ;
	Cardinal n = 0 ;

	_widget = XmCreateForm(parent->widget(), (char *)name, args, n) ;
	installDestroyHandler() ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget list_form = XmCreateForm(_widget, "ListForm", args, n) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	Widget items_label = XmCreateLabel(list_form, "ItemsLabel", args, n) ;
	XtManageChild(items_label) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, items_label) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNvisibleItemCount, 4) ; n++ ;
	XtSetArg(args[n], XmNselectionPolicy, XmBROWSE_SELECT) ; n++ ;
	_items_list = XmCreateScrolledList(list_form, "ItemsList", args, n) ;
	XtManageChild(_items_list) ;
	XtAddCallback(_items_list, XmNbrowseSelectionCallback, listCallback,
		(XtPointer)this) ;
	XtAddCallback(_items_list, XmNdefaultActionCallback, listCallback,
		(XtPointer)this) ;

	XtManageChild(list_form) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, list_form) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget entry_form = XmCreateForm(_widget, "EntryForm", args, n) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	Widget text1_label = XmCreateLabel(entry_form, "Text1Label", args, n) ;
	XtManageChild(text1_label) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget text2_label = XmCreateLabel(entry_form, "Text2Label", args, n) ;
	XtManageChild(text2_label) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, text1_label) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	_text1_field = XmCreateTextField(entry_form, "Text1Field", args, n) ;
	XtAddCallback(_text1_field, XmNactivateCallback, text1_entry_cb,
		(XtPointer)this) ;
	XtManageChild(_text1_field) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, text2_label) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	_text2_field = XmCreateTextField(entry_form, "Text2Field", args, n) ;
	XtAddCallback(_text2_field, XmNactivateCallback, text2_entry_cb,
		(XtPointer)this) ;
	XtManageChild(_text2_field) ;

	XtManageChild(entry_form) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, entry_form) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget sep = XmCreateSeparator(_widget, "Sep", args, n) ;
	XtManageChild(sep) ;

		// Positioning of buttons in the form
	const int nbuttons = 4 ;
	const int nspaces = nbuttons - 1 ;
	const int button_size = 3 ;
	const int space_size = 1 ;
	const int base = nbuttons * button_size + nspaces * space_size  ;
	int current_pos = 0 ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, sep) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNhorizontalSpacing, 10) ; n++ ;
	XtSetArg(args[n], XmNverticalSpacing, 10) ; n++ ;
	XtSetArg(args[n], XmNfractionBase, base) ; n++ ;
	Widget button_manage = XmCreateForm(_widget, "ButtonManage", args, n) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNleftPosition, current_pos) ; n++ ;
	current_pos += button_size ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNrightPosition, current_pos) ; n++ ;
	current_pos += space_size ;
	XtSetArg(args[n], XmNshowAsDefault, True) ; n++ ;
	XtSetArg(args[n], XmNdefaultButtonShadowThickness, 1) ; n++ ;
	XtSetArg(args[n], XmNmarginTop, 2) ; n++ ;
	XtSetArg(args[n], XmNmarginBottom, 2) ; n++ ;
	_ok_button = XmCreatePushButton(button_manage, "OK", args, n) ;
	XtAddCallback(_ok_button, XmNactivateCallback, okCallback,
		(XtPointer)this) ;
	XtManageChild(_ok_button) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNleftPosition, current_pos) ; n++ ;
	current_pos += button_size ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNrightPosition, current_pos) ; n++ ;
	current_pos += space_size ;
	XtSetArg(args[n], XmNshowAsDefault, False) ; n++ ;
	XtSetArg(args[n], XmNdefaultButtonShadowThickness, 1) ; n++ ;
	XtSetArg(args[n], XmNmarginTop, 2) ; n++ ;
	XtSetArg(args[n], XmNmarginBottom, 2) ; n++ ;
	Widget apply_button = XmCreatePushButton(button_manage, "Apply", args, n) ;
	XtAddCallback(apply_button, XmNactivateCallback, applyCallback,
		(XtPointer)this) ;
	XtManageChild(apply_button) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNleftPosition, current_pos) ; n++ ;
	current_pos += button_size ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNrightPosition, current_pos) ; n++ ;
	current_pos += space_size ;
	XtSetArg(args[n], XmNshowAsDefault, False) ; n++ ;
	XtSetArg(args[n], XmNdefaultButtonShadowThickness, 1) ; n++ ;
	XtSetArg(args[n], XmNmarginTop, 2) ; n++ ;
	XtSetArg(args[n], XmNmarginBottom, 2) ; n++ ;
	Widget cancel_button = XmCreatePushButton(button_manage, "Cancel",
		args, n) ;
	XtAddCallback(cancel_button, XmNactivateCallback, cancelCallback,
		(XtPointer)this) ;
	XtManageChild(cancel_button) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNleftPosition, current_pos) ; n++ ;
	current_pos += button_size ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION) ; n++ ;
	XtSetArg(args[n], XmNrightPosition, current_pos) ; n++ ;
	current_pos += space_size ;
	XtSetArg(args[n], XmNshowAsDefault, False) ; n++ ;
	XtSetArg(args[n], XmNdefaultButtonShadowThickness, 1) ; n++ ;
	XtSetArg(args[n], XmNmarginTop, 2) ; n++ ;
	XtSetArg(args[n], XmNmarginBottom, 2) ; n++ ;
	Widget help_button = XmCreatePushButton(button_manage, "Help", args, n) ;
	XtAddCallback(help_button, XmNactivateCallback, helpCallback,
		(XtPointer)this) ;
	XtManageChild(help_button) ;
	XtSetSensitive(help_button, False) ; // for now no help

	XtManageChild(button_manage) ;
}

void TwoPartSelectionBox::
add_item(
	SelectPartConstReference part1,
	SelectPartConstReference part2,
	int position)
{
	_first_parts.push_back(part1) ;
	_second_parts.push_back(part2) ;
	SelectPart decl(part1) ;
	decl += " " ;
	decl += part2 ;
	XmListAddItemUnselected(_items_list, XmCxxString(decl.c_str()), position) ;
}

void TwoPartSelectionBox::
clear_list()
{
	XmListDeleteAllItems(_items_list) ;
	_first_parts.erase(_first_parts.begin(), _first_parts.end()) ;
	_second_parts.erase(_second_parts.begin(), _second_parts.end()) ;
	set_text_field(_text1_field, "") ;
	set_text_field(_text2_field, "") ;
}

TwoPartSelectionBox::SelectPart TwoPartSelectionBox::
selection_text1()
{
	char *text = XmTextFieldGetString(_text1_field) ;
	SelectPart strtext(text) ;
	XtFree(text) ;
	return strtext ;
}

TwoPartSelectionBox::SelectPart TwoPartSelectionBox::
selection_text2()
{
	char *text = XmTextFieldGetString(_text2_field) ;
	SelectPart strtext(text) ;
	XtFree(text) ;
	return strtext ;
}

TwoPartSelectionBox::SelectPart TwoPartSelectionBox::
selected_1()
{
	int pos = get_selected_position() ;
	return pos < 0 ? string() : _first_parts[pos] ;
}

TwoPartSelectionBox::SelectPart TwoPartSelectionBox::
selected_2()
{
	int pos = get_selected_position() ;
	return pos < 0 ? string() : _second_parts[pos] ;
}

void TwoPartSelectionBox::
ok_command(Command *command)
{
	delete _ok_command ;
	_ok_command = command ;
}

void TwoPartSelectionBox::
apply_command(Command *command)
{
	delete _apply_command ;
	_apply_command = command ;
}

void TwoPartSelectionBox::
cancel_command(Command *command)
{
	delete _cancel_command ;
	_cancel_command = command ;
}

void TwoPartSelectionBox::
help_command(Command *command)
{
	delete _help_command ;
	_help_command = command ;
}

void TwoPartSelectionBox::
ok()
{
	if (_ok_command)
		_ok_command->execute() ;
}

void TwoPartSelectionBox::
apply()
{
	if (_apply_command)
		_apply_command->execute() ;
}

void TwoPartSelectionBox::
cancel()
{
	if (_cancel_command)
		_cancel_command->execute() ;
}

void TwoPartSelectionBox::
help()
{
	if (_help_command)
		_help_command->execute() ;
}

void TwoPartSelectionBox::
list(
	XmListCallbackStruct *lcbs)
{
	assert(lcbs->reason == XmCR_SINGLE_SELECT
		|| lcbs->reason == XmCR_BROWSE_SELECT
		|| lcbs->reason == XmCR_DEFAULT_ACTION) ;

	int position = lcbs->item_position ;
	assert (position > 0) ;
	--position ;
	set_text_field(_text1_field, _first_parts[position]) ;
	set_text_field(_text2_field, _second_parts[position]) ;
}

void TwoPartSelectionBox::
listCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	TwoPartSelectionBox *two_part = (TwoPartSelectionBox *)closure ;
	two_part->list((XmListCallbackStruct *)call_data) ;
}

void TwoPartSelectionBox::
okCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	TwoPartSelectionBox *two_part = (TwoPartSelectionBox *)closure ;
	two_part->ok() ;
}

void TwoPartSelectionBox::
applyCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	TwoPartSelectionBox *two_part = (TwoPartSelectionBox *)closure ;
	two_part->apply() ;
}

void TwoPartSelectionBox::
cancelCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	TwoPartSelectionBox *two_part = (TwoPartSelectionBox *)closure ;
	two_part->cancel() ;
}

void TwoPartSelectionBox::
helpCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	TwoPartSelectionBox *two_part = (TwoPartSelectionBox *)closure ;
	two_part->help() ;
}

void TwoPartSelectionBox::
set_text_field(
	Widget w,
	SelectPartConstReference text)
{
	XmTextFieldSetString(w, (char *)text.c_str()) ;
	XmTextFieldSetInsertionPosition(w, XmTextFieldGetLastPosition(w)) ;
}

int TwoPartSelectionBox::
get_selected_position()
{
	int selected_count = 0 ;
	unsigned int *selected_pos = NULL ;

	XtVaGetValues(_items_list,
		XmNselectedPositionCount, &selected_count,
		XmNselectedPositions, &selected_pos,
		NULL) ;
	assert(selected_count <= 1) ;

	return selected_count == 1 ? *selected_pos - 1 : -1 ;
}

void TwoPartSelectionBox::
text1_entry_cb(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	XmProcessTraversal(w, XmTRAVERSE_NEXT_TAB_GROUP) ;
}

void TwoPartSelectionBox::
text2_entry_cb(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	XmProcessTraversal(w, XmTRAVERSE_PREV_TAB_GROUP) ;

	TwoPartSelectionBox *tpsb = (TwoPartSelectionBox *)closure ;
	XtCallCallbacks(tpsb->_ok_button, XmNactivateCallback, call_data) ;
}
