/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: TextEditor.h,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:44:56 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: TextEditor.h,v $
Revision 1.5  1997/07/02 04:44:56  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/02/23 23:44:09  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.3  1996/09/22 01:46:34  andrewm
pre-alpha release

 * Revision 1.2  1996/08/18  17:59:20  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/08/18  17:59:20  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/08/05  01:26:53  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _TextEditor_h_
#define _TextEditor_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <string>

#include "UIComponent.h"
#include <X11/Intrinsic.h>

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Command ;

class TextEditor :
	public UIComponent
{
public:
	TextEditor(const char *name, UIComponent *parent) ;
	~TextEditor() ;
	virtual const char *className(void) const { return "TextEditor" ; }
	virtual void manage() const ;

	void save_command(Command *command) ;
	void cancel_command(Command *command) ;
	bool modified() const { return _modified ; }
	void modified(bool new_modified) { _modified = new_modified ; }

	string get_text() ;
	void set_text(const char *new_text) ;

protected:
	virtual void save() ;
	virtual void cancel() ;

private:
	Command *_save_command ;
	Command *_cancel_command ;
	bool _modified ;
	Widget _text_widget ;
	Widget _search_entry ;
	Widget _replace_entry ;

private:
	static void save_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static void cancel_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;

	static void cut_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static void copy_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static void paste_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static void clear_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static Time get_time(XEvent *event) ;

	static void fforw_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static void fback_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static void replace_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static void rnext_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
	static void rall_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;

	static void change_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
} ;


#endif /* _TextEditor_h_ */
