/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: TextEditor.cc,v $
$Revision: 1.6 $
$Date: 1997/07/02 04:44:56 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: TextEditor.cc,v $
Revision 1.6  1997/07/02 04:44:56  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.5  1997/02/23 23:44:08  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.4  1996/11/17 21:50:49  andrewm
Converting to the new version of g++ (2.7.2) and now everything
is under CVS.

// Revision 1.3  1996/09/22  01:20:08  andrewm
// pre-alpha release
//
// Revision 1.3  1996/09/22  01:20:08  andrewm
// pre-alpha release
//
// Revision 1.2  1996/08/18  17:59:20  andrewm
// checkpoint
//
// Revision 1.1  1996/08/05  01:26:53  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <strstream.h>
#include <X11/Xmu/Editres.h>
#include <string.h>

#include "TextEditor.h"
#include "Command.h"
#include <Xm/XmAll.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: TextEditor.cc,v $ $Revision: 1.6 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

TextEditor::
TextEditor(
	const char *name,
	UIComponent *parent) :
		_save_command(NULL),
		_cancel_command(NULL),
		_modified(false)
{
	Widget parent_widget = parent->widget() ;
	Arg args[10] ;
	Cardinal n ;

		// The top level
	char title[64] ;
	ostrstream out(title, sizeof(title)) ;
	out << "\"" << name << "\" Code" << ends ;

	Screen *screen = XtScreen(parent_widget) ;
	Pixmap icon_pixmap = XmGetPixmap(screen, "editor.xpm",
		BlackPixelOfScreen(screen), WhitePixelOfScreen(screen)) ;

	n = 0 ;
	XtSetArg(args[n], XmNtitle, title) ; n++ ;
	XtSetArg(args[n], XmNiconName, title) ; n++ ;
	XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING) ; n++ ;
	if (icon_pixmap)
	{
		XtSetArg(args[n], XmNiconPixmap, icon_pixmap) ; n++ ;
	}
	_widget = XtAppCreateShell("CodeEdit", "TextEditor",
		topLevelShellWidgetClass, XtDisplay(parent_widget), args, n) ;
	installDestroyHandler() ;

		// make the WM "close" menu item do the same as cancel
	XmAddWMProtocolCallback(_widget,
		XmInternAtom(XtDisplay(_widget), "WM_DELETE_WINDOW", False),
		cancel_cb, (XtPointer)this) ;

	XtAddEventHandler(_widget, (EventMask)0, True,
		_XEditResCheckMessages, NULL) ;

		// A form is used to control the layout of the other widgets.
		// The editor is composed of menu bar, an area used for
		// search/replace controls, and a text widget for holding the text.
	Widget form = XmCreateForm(_widget, "Form", NULL, 0) ;

	Widget menu_bar = XmCreateMenuBar(form, "MenuBar", NULL, 0) ;
	Widget sep1 = XmCreateSeparator(form, "sep1", NULL, 0) ;
	XtManageChild(sep1) ;
	_text_widget = XmCreateScrolledText(form, "Text", NULL, 0) ;
	XtManageChild(_text_widget) ;
	XtAddCallback(_text_widget, XmNvalueChangedCallback, change_cb,
		(XtPointer)this) ;
	Widget sep2 = XmCreateSeparator(form, "sep2", NULL, 0) ;
	XtManageChild(sep2) ;
	Widget search = XmCreateRowColumn(form, "SearchControl", NULL, 0) ;

	XtVaSetValues(menu_bar,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_NONE,
		NULL) ;
	XtVaSetValues(sep1,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, menu_bar,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_NONE,
		NULL) ;
	Widget scroll = XtParent(_text_widget) ;
	XtVaSetValues(scroll,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, sep1,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, sep2,
		NULL) ;
	XtVaSetValues(sep2,
		XmNtopAttachment, XmATTACH_NONE,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, search,
		NULL) ;
	XtVaSetValues(search,
		XmNtopAttachment, XmATTACH_NONE,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		NULL) ;

		// the menu bar details
	Widget pulldown = XmCreatePulldownMenu(menu_bar, "file_pulldown", NULL, 0) ;
	n = 0 ;
	XtSetArg(args[n], XmNsubMenuId, pulldown) ; n++ ;
	Widget menu_button = XmCreateCascadeButton(menu_bar, "file", args, n) ;
	XtManageChild(menu_button) ;
	Widget button = XmCreatePushButton(pulldown, "save", NULL, 0) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, save_cb, (XtPointer)this) ;
	button = XmCreatePushButton(pulldown, "cancel", NULL, 0) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, cancel_cb, (XtPointer)this) ;

	pulldown = XmCreatePulldownMenu(menu_bar, "edit_pulldown", NULL, 0) ;
	n = 0 ;
	XtSetArg(args[n], XmNsubMenuId, pulldown) ; n++ ;
	menu_button = XmCreateCascadeButton(menu_bar, "edit", args, n) ;
	XtManageChild(menu_button) ;
	button = XmCreatePushButton(pulldown, "cut", NULL, 0) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, cut_cb, (XtPointer)this) ;
	button = XmCreatePushButton(pulldown, "copy", NULL, 0) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, copy_cb, (XtPointer)this) ;
	button = XmCreatePushButton(pulldown, "paste", NULL, 0) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, paste_cb, (XtPointer)this) ;
	sep1 = XmCreateSeparator(pulldown, "edit_sep", NULL, 0) ;
	XtManageChild(sep1) ;
	button = XmCreatePushButton(pulldown, "clear", NULL, 0) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, clear_cb, (XtPointer)this) ;

	pulldown = XmCreatePulldownMenu(menu_bar, "search_pulldown", NULL, 0) ;
	n = 0 ;
	XtSetArg(args[n], XmNsubMenuId, pulldown) ; n++ ;
	menu_button = XmCreateCascadeButton(menu_bar, "search", args, n) ;
	XtManageChild(menu_button) ;
	button = XmCreatePushButton(pulldown, "find_forward", NULL, 0) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, fforw_cb, (XtPointer)this) ;
	button = XmCreatePushButton(pulldown, "find_backward", NULL, 0) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, fback_cb, (XtPointer)this) ;
	button = XmCreatePushButton(pulldown, "replace", NULL, 0) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, replace_cb, (XtPointer)this) ;
	button = XmCreatePushButton(pulldown, "replace_find_next", NULL, 0) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, rnext_cb, (XtPointer)this) ;
	button = XmCreatePushButton(pulldown, "replace_all", NULL, 0) ;
	XtManageChild(button) ;
	XtAddCallback(button, XmNactivateCallback, rall_cb, (XtPointer)this) ;

	XtManageChild(menu_bar) ;

		// the search/replace controls
	Widget label = XmCreateLabel(search, "search_pattern", NULL, 0) ;
	XtManageChild(label) ;
	n = 0 ;
	XtSetArg(args[n], XmNcolumns, 20) ; n++ ;
	_search_entry = XmCreateTextField(search, "search_entry", args, n) ;
	XtManageChild(_search_entry) ;
	XtAddCallback(_search_entry, XmNactivateCallback, fforw_cb,
		(XtPointer)this) ;
	label = XmCreateLabel(search, "replace_pattern", NULL, 0) ;
	XtManageChild(label) ;
	_replace_entry = XmCreateTextField(search, "replace_entry", args, n) ;
	XtManageChild(_replace_entry) ;
	XtAddCallback(_replace_entry, XmNactivateCallback, replace_cb,
		(XtPointer)this) ;

	XtManageChild(search) ;

	XtManageChild(form) ;
}

TextEditor::
~TextEditor()
{
	delete _save_command ;
	delete _cancel_command ;
}

void TextEditor::
manage() const
{
	XtPopup(_widget, XtGrabNone) ;
}

void TextEditor::
save_command(Command *command)
{
	delete _save_command ;
	_save_command = command ;
}

void TextEditor::
cancel_command(Command *command)
{
	delete _cancel_command ;
	_cancel_command = command ;
}

void TextEditor::
save()
{
	if (_save_command)
		_save_command->execute() ;
	XtPopdown(_widget) ;
}

void TextEditor::
cancel()
{
	if (_cancel_command)
		_cancel_command->execute() ;
	_modified = false ;
	XtPopdown(_widget) ;
}

string TextEditor::
get_text()
{
	char *s = XmTextGetString(_text_widget) ;
	string st(s) ;
	XtFree(s) ;
	_modified = false ;
	return st ;
}

void TextEditor::
set_text(
	const char *text)
{
	XmTextReplace(_text_widget, 0, XmTextGetLastPosition(_text_widget),
		(char *)text) ;
	XmTextSetInsertionPosition(_text_widget, 0) ;
	_modified = false ;
}

void TextEditor::
save_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	TextEditor *te = (TextEditor *)closure ;
	te->save() ;
}

void TextEditor::
cancel_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	TextEditor *te = (TextEditor *)closure ;
	te->cancel() ;
}

void TextEditor::
cut_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	TextEditor *te = (TextEditor *)closure ;
	XEvent *event = ((XmPushButtonCallbackStruct *)callback_data)->event ;
	XmTextCut(te->_text_widget, get_time(event)) ;
}

void TextEditor::
copy_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	TextEditor *te = (TextEditor *)closure ;
	XEvent *event = ((XmPushButtonCallbackStruct *)callback_data)->event ;
	XmTextCopy(te->_text_widget, get_time(event)) ;
}

void TextEditor::
paste_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	TextEditor *te = (TextEditor *)closure ;
	XmTextPaste(te->_text_widget) ;
}

void TextEditor::
clear_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	TextEditor *te = (TextEditor *)closure ;
	XEvent *event = ((XmPushButtonCallbackStruct *)callback_data)->event ;
	XmTextClearSelection(te->_text_widget, get_time(event)) ;
}

Time TextEditor::
get_time(
	XEvent *event)
{
	Time when ;

	switch (event->type)
	{
	case ButtonRelease:
		when = event->xbutton.time ;
		break ;

	case KeyRelease:
		when = event->xkey.time ;
		break ;

	default:
		when = CurrentTime ;
		break ;
	}

	return when ;
}

void TextEditor::
fforw_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	TextEditor *te = (TextEditor *)closure ;
	Widget text_widget = te->_text_widget ;

	char *search_string = XmTextGetString(te->_search_entry) ;
	if (search_string == NULL || *search_string == '\0')
		return ;
	int search_len = strlen(search_string) ;

	XmTextPosition pos = XmTextGetInsertionPosition(text_widget) + 1 ;
	bool found = XmTextFindString(text_widget, pos, search_string,
		XmTEXT_FORWARD, &pos) ;
	if (found)
	{
		XEvent *event = ((XmPushButtonCallbackStruct *)callback_data)->event ;
		Time time = get_time(event) ;
		XmTextSetSelection(text_widget, pos, pos + search_len, time) ;
		XmTextSetInsertionPosition(text_widget, pos + search_len) ;
	}
	else
	{
		XBell(XtDisplay(text_widget), 100) ;
	}

	XtFree(search_string) ;
}

void TextEditor::
fback_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	TextEditor *te = (TextEditor *)closure ;
	Widget text_widget = te->_text_widget ;

	char *search_string = XmTextGetString(te->_search_entry) ;
	if (search_string == NULL || *search_string == '\0')
		return ;
	int search_len = strlen(search_string) ;

	XmTextPosition pos = XmTextGetInsertionPosition(text_widget)
		- search_len - 1 ;
	bool found = XmTextFindString(text_widget, pos, search_string,
		XmTEXT_BACKWARD, &pos) ;
	if (found)
	{
		XEvent *event = ((XmPushButtonCallbackStruct *)callback_data)->event ;
		Time time = get_time(event) ;
		XmTextSetSelection(text_widget, pos, pos + search_len, time) ;
		XmTextSetInsertionPosition(text_widget, pos) ;
	}
	else
	{
		XBell(XtDisplay(text_widget), 100) ;
	}

	XtFree(search_string) ;
}

void TextEditor::
replace_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	TextEditor *te = (TextEditor *)closure ;
	Widget text_widget = te->_text_widget ;
	char *replace_string = XmTextGetString(te->_replace_entry) ;
	if (replace_string == NULL || *replace_string == '\0')
		return ;
	int replace_len = strlen(replace_string) ;

	XmTextPosition left ;
	XmTextPosition right ;
	if (XmTextGetSelectionPosition(text_widget, &left, &right))
	{
		if (left != right)
		{
			XmTextReplace(text_widget, left, right, replace_string) ;
			XEvent *event =
				((XmPushButtonCallbackStruct *)callback_data)->event ;
			Time time = get_time(event) ;
			XmTextSetSelection(text_widget, left, left + replace_len, time) ;
			XmTextSetInsertionPosition(text_widget, left + replace_len) ;
		}
	}
	else
	{
		XBell(XtDisplay(text_widget), 100) ;
	}

	XtFree(replace_string) ;
}

void TextEditor::
rnext_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	replace_cb(widget, closure, callback_data) ;
	fforw_cb(widget, closure, callback_data) ;
}

void TextEditor::
rall_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	TextEditor *te = (TextEditor *)closure ;
	Widget text_widget = te->_text_widget ;

	char *search_string = XmTextGetString(te->_search_entry) ;
	if (search_string == NULL || *search_string == '\0')
		return ;
	int search_len = strlen(search_string) ;

	char *replace_string = XmTextGetString(te->_replace_entry) ;
	if (replace_string == NULL || *replace_string == '\0')
	{
		XtFree(search_string) ;
		return ;
	}
	int replace_len = strlen(replace_string) ;

	for (XmTextPosition pos = 0 ;
		XmTextFindString(text_widget, pos, search_string,
			XmTEXT_FORWARD, &pos) ;
		pos += replace_len)
	{
		XmTextReplace(text_widget, pos, pos + search_len, replace_string) ;
	}

	XtFree(search_string) ;
	XtFree(replace_string) ;
}

void TextEditor::
change_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	TextEditor *te = (TextEditor *)closure ;
	te->_modified = true ;
}
