/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Selection.h,v $
$Revision: 1.8 $
$Date: 1997/07/02 04:44:55 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Selection.h,v $
Revision 1.8  1997/07/02 04:44:55  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.7  1997/04/08 04:34:24  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

Revision 1.6  1997/02/23 23:44:08  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.5  1996/10/01 04:40:29  andrewm
checkpoint and revision

 * Revision 1.4  1996/09/22  01:46:34  andrewm
 * pre-alpha release
 *
 * Revision 1.3  1996/08/05  01:26:53  andrewm
 * checkpoint
 *
 * Revision 1.3  1996/08/05  01:26:53  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/07/27  20:58:10  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/07/13  19:32:43  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _Selection_h_
#define _Selection_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <string>

#include "UIComponent.h"
#include "Command.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Selection :
	public UIComponent
{
public:
	virtual ~Selection() ;

	virtual void manage() const ;
	virtual const char *className() const { return "Selection" ; }

	virtual void add_item(const string& item, int position) ;
	virtual void clear_list() ;
	virtual void selection_text(const string& text) ;
	virtual string selection_text() ;

	virtual void ok_command(XmCommand *command) ;
	virtual void apply_command(XmCommand *command) ;
	virtual void cancel_command(XmCommand *command) ;
	virtual void help_command(XmCommand *command) ;
	virtual void nomatch_command(XmCommand *command) ;

protected:
	XmCommand *_ok_command ;
	XmCommand *_apply_command ;
	XmCommand *_cancel_command ;
	XmCommand *_help_command ;
	XmCommand *_nomatch_command ;

protected:
	Selection() ;
	virtual void ok(XmAnyCallbackStruct *callback_data) ;
	virtual void apply(XmAnyCallbackStruct *callback_data) ;
	virtual void cancel(XmAnyCallbackStruct *callback_data) ;
	virtual void help(XmAnyCallbackStruct *callback_data) ;
	virtual void nomatch(XmAnyCallbackStruct *callback_data) ;

protected:
	void install_callbacks() ;
	static void okCallback(Widget w, XtPointer closure, XtPointer call_data) ;
	static void applyCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void cancelCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void helpCallback(Widget w, XtPointer closure, XtPointer call_data) ;
	static void nomatchCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
} ;


#endif /* _Selection_h_ */
