/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Selection.cc,v $
$Revision: 1.9 $
$Date: 1997/07/02 04:44:55 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Selection.cc,v $
Revision 1.9  1997/07/02 04:44:55  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.8  1997/04/12 21:14:56  andrewm
Checkpoint after adding the event dialog.

Revision 1.7  1997/04/08 04:34:24  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

Revision 1.6  1997/02/23 23:44:08  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.5  1996/11/14 06:20:45  andrewm
checkpoint

// Revision 1.4  1996/10/01  04:40:29  andrewm
// checkpoint and revision
//
// Revision 1.3  1996/09/22  01:46:34  andrewm
// pre-alpha release
//
// Revision 1.2  1996/07/27  20:58:10  andrewm
// checkpoint
//
// Revision 1.2  1996/07/27  20:58:10  andrewm
// checkpoint
//
// Revision 1.1  1996/07/13  19:32:43  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <assert.h>

#include "Selection.h"

#include <Xm/XmAll.h>
#include <XmCxx/CxxXmString.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: Selection.cc,v $ $Revision: 1.9 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

Selection::
Selection() :
		_ok_command(NULL),
		_apply_command(NULL),
		_cancel_command(NULL),
		_help_command(NULL),
		_nomatch_command(NULL)
{
}

Selection::
~Selection()
{
	delete _ok_command ;
	delete _apply_command ;
	delete _cancel_command ;
	delete _help_command ;
	delete _nomatch_command ;
}

void Selection::
manage() const
{
	if (!_ok_command)
	{
		Widget w = XtNameToWidget(_widget, "OK") ;
		if (w) XtSetSensitive(w, False) ;
	}
	if (!_apply_command)
	{
		Widget w = XtNameToWidget(_widget, "Apply") ;
		if (w) XtUnmanageChild(w) ;
	}
	if (!_cancel_command)
	{
		Widget w = XtNameToWidget(_widget, "Cancel") ;
		if (w) XtSetSensitive(w, False) ;
	}
	if (!_help_command)
	{
		Widget w = XtNameToWidget(_widget, "Help") ;
		if (w) XtSetSensitive(w, False) ;
	}
	UIComponent::manage() ;
}

void Selection::
add_item(
	const string& item,
	int position)
{
	Widget list_widget = XtNameToWidget(_widget, "ItemsListSW.ItemsList") ;
	XmCxxString list_item(item.c_str()) ;
	XmListAddItem(list_widget, (XmString)list_item, position) ;
}

void Selection::
clear_list()
{
	Widget list_widget = XtNameToWidget(_widget, "ItemsListSW.ItemsList") ;
	XmListDeleteAllItems(list_widget) ;
	Widget text_widget = XtNameToWidget(_widget, "Text") ;
	XmTextFieldSetString(text_widget, "") ;
}

void Selection::
selection_text(
	const string& text)
{
	Widget text_widget = XtNameToWidget(_widget, "Text") ;
	XmTextFieldSetString(text_widget, (char *)text.c_str()) ;
	XmTextFieldSetInsertionPosition(text_widget,
		XmTextFieldGetLastPosition(text_widget)) ;
}

string Selection::
selection_text()
{
	Widget text_widget = XtNameToWidget(_widget, "Text") ;
	char *text = XmTextGetString(text_widget) ;
	string strtext(text) ;
	XtFree(text) ;
	return strtext ;
}

void Selection::
ok_command(
	XmCommand *command)
{
	delete _ok_command ;
	_ok_command = command ;
}

void Selection::
apply_command(
	XmCommand *command)
{
	delete _apply_command ;
	_apply_command = command ;
}

void Selection::
cancel_command(
	XmCommand *command)
{
	delete _cancel_command ;
	_cancel_command = command ;
}

void Selection::
help_command(
	XmCommand *command)
{
	delete _help_command ;
	_help_command = command ;
}

void Selection::
nomatch_command(
	XmCommand *command)
{
	delete _nomatch_command ;
	_nomatch_command = command ;
}

/*
========================================
Protected functions
========================================
*/
void Selection::
ok(
	XmAnyCallbackStruct *callback_data)
{
	if (_ok_command)
		_ok_command->execute(callback_data) ;
}

void Selection::
apply(
	XmAnyCallbackStruct *callback_data)
{
	if (_apply_command)
		_apply_command->execute(callback_data) ;
}

void Selection::
cancel(
	XmAnyCallbackStruct *callback_data)
{
	if (_cancel_command)
		_cancel_command->execute(callback_data) ;
}

void Selection::
help(
	XmAnyCallbackStruct *callback_data)
{
	if (_help_command)
		_help_command->execute(callback_data) ;
}

void Selection::
nomatch(
	XmAnyCallbackStruct *callback_data)
{
	if (_nomatch_command)
		_nomatch_command->execute(callback_data) ;
}

void Selection::
install_callbacks()
{
	XtAddCallback(_widget, XmNokCallback, okCallback, (XtPointer)this) ;
	XtAddCallback(_widget, XmNapplyCallback, applyCallback, (XtPointer)this) ;
	XtAddCallback(_widget, XmNcancelCallback, cancelCallback, (XtPointer)this) ;
	XtAddCallback(_widget, XmNhelpCallback, helpCallback, (XtPointer)this) ;
	XtAddCallback(_widget, XmNnoMatchCallback, nomatchCallback,
		(XtPointer)this) ;
}

void Selection::
okCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	assert(((XmAnyCallbackStruct *)call_data)->reason == XmCR_OK) ;
	Selection *selection = (Selection *)closure ;
	selection->ok((XmAnyCallbackStruct *)call_data) ;
}

void Selection::
applyCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	assert(((XmAnyCallbackStruct *)call_data)->reason == XmCR_APPLY) ;
	Selection *selection = (Selection *)closure ;
	selection->apply((XmAnyCallbackStruct *)call_data) ;
}

void Selection::
cancelCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	assert(((XmAnyCallbackStruct *)call_data)->reason == XmCR_CANCEL) ;
	Selection *selection = (Selection *)closure ;
	selection->cancel((XmAnyCallbackStruct *)call_data) ;
}

void Selection::
helpCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	assert(((XmAnyCallbackStruct *)call_data)->reason == XmCR_HELP) ;
	Selection *selection = (Selection *)closure ;
	selection->help((XmAnyCallbackStruct *)call_data) ;
}

void Selection::
nomatchCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	assert(((XmAnyCallbackStruct *)call_data)->reason == XmCR_NO_MATCH) ;
	Selection *selection = (Selection *)closure ;
	selection->nomatch((XmAnyCallbackStruct *)call_data) ;
}
