/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: RubberBand.cc,v $
$Revision: 1.2 $
$Date: 1997/07/02 04:44:54 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: RubberBand.cc,v $
Revision 1.2  1997/07/02 04:44:54  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.1  1997/03/18 06:50:59  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "RubberBand.h"
#include "GraphicRenderer.h"
#include "Application.h"
#include "MainWindow.h"
#include "DrawingArea.h"

#include <builtin.h>
#include <minmax.h>
#include <X11/cursorfont.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: RubberBand.cc,v $ $Revision: 1.2 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

RubberBand::
RubberBand() :
		_banding_cursor(XCreateFontCursor(Application::instance()->display(),
			XC_fleur))
{
}

RubberBand::
~RubberBand()
{
	if (_banding_cursor)
		XFreeCursor(Application::instance()->display(), _banding_cursor) ;
}

void RubberBand::
start_banding(
	const Point& origin)
{
	define_cursor(_banding_cursor) ;
	_origin = origin ;
	_band.origin() = origin ;
	_band.width() = _band.height() = 1 ;

	GraphicRenderer::instance().rect(_band) ;
}

void RubberBand::
new_band(
	const Point& corner)
{
	GraphicRenderer& render = GraphicRenderer::instance() ;
	render.rect(_band) ;
	new_banding_box(corner) ;
	render.rect(_band) ;
}

void RubberBand::
stop_banding(
	const Point& corner)
{
	GraphicRenderer::instance().rect(_band) ;
	new_banding_box(corner) ;
	define_cursor(None) ;
}

void RubberBand::
define_cursor(
	Cursor cursor)
{
	Application *appl = Application::instance() ;
	Display *display = appl->display() ;
	Window window = XtWindow(appl->main_window()->drawing_area()->widget()) ;
	XDefineCursor(display, window, cursor) ;
}

void RubberBand::
new_banding_box(
	const Point& corner)
{
	_band.origin().x() = min(_origin.x(), corner.x()) ;
	_band.origin().y() = min(_origin.y(), corner.y()) ;
	_band.width() = abs(corner.x() - _origin.x()) ;
	_band.height() = abs(corner.y() - _origin.y()) ;
}
