/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: ObserverMenu.cc,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:44:53 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: ObserverMenu.cc,v $
Revision 1.5  1997/07/02 04:44:53  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/02/23 23:44:07  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.3  1996/09/22 01:46:34  andrewm
pre-alpha release

// Revision 1.2  1996/08/05  01:26:53  andrewm
// checkpoint
//
// Revision 1.2  1996/08/05  01:26:53  andrewm
// checkpoint
//
// Revision 1.1  1996/07/27  20:58:10  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "ObserverMenu.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: ObserverMenu.cc,v $ $Revision: 1.5 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

template<class Obsvd>
ObserverMenuButton<Obsvd>::
ObserverMenuButton(
	const char *name,
	UIComponent *parent) :
		MenuButton(name, parent),
		Observer()
{
}

template<class Obsvd>
void ObserverMenuButton<Obsvd>::
observe(
	Obsvd *subject,
	bool (Obsvd::* state_func)())
{
	_observed = subject ;
	_get_state = state_func ;
	_observed->attach(this) ;
}

template<class Obsvd>
void ObserverMenuButton<Obsvd>::
update(
	Subject *subject)
{
	if (_observed == subject)
	{
		set_sensitive((_observed->*_get_state)()) ;
	}
}

template<class Obsvd>
ObserverMenuPulldown<Obsvd>::
ObserverMenuPulldown(
	const char *name,
	UIComponent *parent) :
		MenuPulldown(name, parent),
		Observer()
{
}

template<class Obsvd>
void ObserverMenuPulldown<Obsvd>::
observe(
	Obsvd *subject,
	bool (Obsvd::* state_func)())
{
	_observed = subject ;
	_get_state = state_func ;
	_observed->attach(this) ;
}

template<class Obsvd>
void ObserverMenuPulldown<Obsvd>::
update(
	Subject *subject)
{
	if (_observed == subject)
	{
		set_sensitive((_observed->*_get_state)()) ;
	}
}
