/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: MenuComponent.cc,v $
$Revision: 1.3 $
$Date: 1997/07/02 04:44:51 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MenuComponent.cc,v $
Revision 1.3  1997/07/02 04:44:51  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.2  1997/03/18 06:50:59  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.1  1997/02/23 23:44:05  andrewm
Checkpoint.  Things seem to be working reasonably well.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "MenuComponent.h"
#include "Command.h"

#include <algorithm>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: MenuComponent.cc,v $ $Revision: 1.3 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

MenuComposite::
~MenuComposite()
{
	for (MenuComponentListConstIter component_iter = _component_list.begin() ;
		component_iter != _component_list.end() ; ++component_iter)
	{
		delete *component_iter ;
	}
}

void MenuComposite::
manage() const
{
	MenuComponent::manage() ;

	for (MenuComponentListConstIter component_iter = _component_list.begin() ;
		component_iter != _component_list.end() ; ++component_iter)
	{
		(*component_iter)->manage() ;
	}
}

MenuLeaf::
~MenuLeaf()
{
	delete _command ;
}

void MenuLeaf::
command(
	Command *new_command)
{
	delete _command ;
	_command = new_command ;
}

void MenuLeaf::
activateCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	MenuLeaf *obj = (MenuLeaf *)closure ;
	if (obj->_command)
		obj->_command->execute() ;
}
